@extends('landingpage::themes.job_board.layouts.app')

{{-- $page is constructed in FrontendController for meta tags --}}
{{-- $company is the company model instance --}}
{{-- $products is the paginated collection of products --}}

@section('content')
<div class="container mx-auto px-4 py-8">
    <div class="mb-6">
        <a href="{{ route('theme.company.show', $company->slug) }}" class="text-indigo-600 dark:text-indigo-400 hover:underline">&larr; Back to {{ $company->name }}'s Profile</a>
    </div>

    <h1 class="text-3xl font-bold text-gray-800 dark:text-gray-100 mb-6">Products from {{ $company->name }}</h1>

    @if($products->isEmpty())
        <div class="bg-white dark:bg-slate-800 shadow-md rounded-lg p-6 text-center">
            <p class="text-gray-600 dark:text-gray-400 text-lg">This company currently has no products listed.</p>
        </div>
    @else
        <div class="grid grid-cols-1 sm:grid-cols-2 md:grid-cols-3 lg:grid-cols-4 gap-6">
            @foreach($products as $product)
                <div class="bg-white dark:bg-slate-800 rounded-lg shadow-md overflow-hidden hover:shadow-lg transition-shadow duration-300">
                    <a href="{{ route('theme.product.show', $product->slug) }}" class="block">
                        @if($product->images && !empty($product->images[0]))
                            <img src="{{ Storage::url($product->images[0]) }}" alt="{{ $product->name }}" class="w-full h-48 object-cover">
                        @else
                            <div class="w-full h-48 bg-slate-200 dark:bg-slate-700 flex items-center justify-center text-slate-400 dark:text-slate-500">
                                <i class="fas fa-image fa-3x"></i>
                            </div>
                        @endif
                        <div class="p-4">
                            <h4 class="font-semibold text-md text-gray-800 dark:text-gray-100 truncate" title="{{ $product->name }}">{{ $product->name }}</h4>
                            <p class="text-sm text-gray-700 dark:text-gray-200 font-bold">${{ number_format($product->price, 2) }}</p>
                        </div>
                    </a>
                </div>
            @endforeach
        </div>

        <div class="mt-8">
            {{ $products->links() }}
        </div>
    @endif
</div>
@endsection