{{-- resources/views/themes/general/sections/services.blade.php --}}
@php
    $sectionTitle = $section->title ?? 'Our Services';
    $services = $section->content['services_list'] ?? [];
    // Default placeholder icon (SVG)
    $defaultIcon = '<svg class="w-12 h-12 text-purple-500" fill="none" stroke="currentColor" viewBox="0 0 24 24" xmlns="http://www.w3.org/2000/svg"><path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M9.75 17L9 20l-1 1h8l-1-1-.75-3M3 13h18M5 17h14a2 2 0 002-2V5a2 2 0 00-2-2H5a2 2 0 00-2 2v10a2 2 0 002 2z"></path></svg>';

    // Fallback for demonstration if $services is empty (remove for production if not needed)
    // if (empty($services)) {
    //     $services = [
    //         ['title' => 'Web Development', 'description' => 'Creating stunning and performant websites tailored to your needs.', 'visual_type' => 'icon', 'icon_html' => $defaultIcon, 'link' => '#web-development'],
    //         ['title' => 'AI Solutions', 'description' => 'Leveraging AI to build smart applications.', 'visual_type' => 'image', 'image_url' => 'https://via.placeholder.com/100x100.png?text=AI', 'link' => '#ai-solutions'],
    //         ['title' => 'Cloud Services', 'description' => 'Scalable cloud infrastructure.', 'visual_type' => 'icon', 'icon_html' => '<svg class="w-12 h-12 text-purple-500" fill="none" stroke="currentColor" viewBox="0 0 24 24"><path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M3 15a4 4 0 004 4h9a5 5 0 10-.1-9.999A5.002 5.002 0 1012 3a5.002 5.002 0 00-4.999 5.001A4 4 0 003 15z"></path></svg>', 'link' => '#cloud-services'],
    //     ];
    // }
@endphp

<section class="services-carousel-section py-16 bg-white dark:bg-gray-900">
    <div class="container mx-auto px-4 sm:px-6 lg:px-8">
        <h2 class="text-3xl font-bold text-center text-gray-800 dark:text-white mb-12">
            {{ $sectionTitle }}
        </h2>
        @if(!empty($services))
        <!-- Swiper -->
        <div class="swiper services-swiper">
            <div class="swiper-wrapper">
                @foreach ($services as $service)
                    <div class="swiper-slide h-auto p-2"> {{-- h-auto for variable height content, p-2 for spacing --}}
                        <div class="bg-gray-50 dark:bg-gray-800 rounded-lg p-6 md:p-8 hover:bg-gray-100 dark:hover:bg-gray-700 transition-colors duration-300 h-full flex flex-col">
                            <div class="mb-4 flex justify-center md:justify-start h-12 w-12 items-center"> {{-- Fixed size container for visual --}}
                                @if(($service['visual_type'] ?? 'icon') === 'image' && !empty($service['image_url']))
                                    <img src="{{ $service['image_url'] }}" alt="{{ $service['title'] }} image" class="max-h-full max-w-full object-contain">
                                @elseif(!empty($service['icon_html']))
                                    {!! $service['icon_html'] !!}
                                @else
                                    {!! $defaultIcon !!} {{-- Default placeholder icon --}}
                                @endif
                            </div>

                            <h3 class="text-xl font-semibold text-gray-900 dark:text-gray-100 mb-3">{{ $service['title'] }}</h3>
                            <p class="text-gray-700 dark:text-gray-300 text-sm leading-relaxed flex-grow">
                                {{ $service['description'] }}
                            </p>
                            <a href="{{ $service['link'] ?? '#' }}" class="text-purple-600 hover:text-purple-700 dark:text-purple-400 dark:hover:text-purple-300 font-medium mt-4 inline-block self-start">
                                Learn More &rarr;
                            </a>
                        </div>
                    </div>
                @endforeach
            </div>
            <!-- Add Pagination -->
            <div class="swiper-pagination relative pt-8"></div>
        </div>
        @else
            <p class="text-center text-gray-600 dark:text-gray-400">Our services will be listed here soon.</p>
        @endif
    </div>
</section>

@pushOnce('styles')
    <link rel="stylesheet" href="https://unpkg.com/swiper/swiper-bundle.min.css" />
@endPushOnce

@pushOnce('scripts')
    <script src="https://unpkg.com/swiper/swiper-bundle.min.js"></script>
    <script>
        document.addEventListener('DOMContentLoaded', function () {
            const servicesSwiper = new Swiper('.services-swiper', {
                loop: false, // Set to true for infinite loop if desired
                slidesPerView: 1,
                spaceBetween: 30,
                pagination: {
                    el: '.swiper-pagination',
                    clickable: true,
                },
                breakpoints: {
                    640: { slidesPerView: 2, spaceBetween: 20 },
                    1024: { slidesPerView: 3, spaceBetween: 30 },
                }
            });
        });
    </script>
@endPushOnce