{{--
    Expects $content to have keys like:
    $content['title']
    $content['subtitle']
    $content['search_placeholder_keywords']
    $content['search_placeholder_location']
    $content['background_image_url'] (optional)
--}}
@php
    $title = $content['title'] ?? 'Find Your Dream Job';
    $subtitle = $content['subtitle'] ?? 'Thousands of job openings from top companies are waiting for you.';
    $bgImage = isset($content['background_image_url']) ? "background-image: url('" . asset('storage/' . $content['background_image_url']) . "');" : '';
    $bgColor = !$bgImage ? 'bg-slate-700 dark:bg-slate-800' : '';
@endphp

<section class="py-20 md:py-32 text-white {{ $bgColor }} bg-cover bg-center" style="{{ $bgImage }}">
    <div class="container mx-auto px-4 sm:px-6 lg:px-8 text-center">
        <h1 class="text-4xl md:text-5xl font-bold mb-4">{{ $title }}</h1>
        <p class="text-lg md:text-xl mb-8 max-w-2xl mx-auto opacity-90">{{ $subtitle }}</p>

        <form action="{{ url('/jobs') }}" method="GET" class="max-w-2xl mx-auto bg-white dark:bg-slate-700 p-4 rounded-lg shadow-xl grid grid-cols-1 md:grid-cols-3 gap-3">
            <input type="text" name="keywords" placeholder="{{ $content['search_placeholder_keywords'] ?? 'Keywords (e.g., Developer)' }}"
                   class="col-span-1 md:col-span-1 p-3 border border-slate-300 dark:border-slate-600 rounded-md focus:ring-blue-500 focus:border-blue-500 text-slate-700 dark:text-slate-200 dark:bg-slate-600">
            <input type="text" name="location" placeholder="{{ $content['search_placeholder_location'] ?? 'Location (e.g., City, State)' }}"
                   class="col-span-1 md:col-span-1 p-3 border border-slate-300 dark:border-slate-600 rounded-md focus:ring-blue-500 focus:border-blue-500 text-slate-700 dark:text-slate-200 dark:bg-slate-600">
            <button type="submit"
                    class="col-span-1 md:col-span-1 w-full bg-blue-600 hover:bg-blue-700 text-white font-semibold p-3 rounded-md transition duration-150">
                Search Jobs
            </button>
        </form>
    </div>
</section>