{{--
    Expects:
    - $content: array of section settings (e.g., title, subtitle, bg_color, text_color, items_to_show, view_all_link)
    - $featured_tenders_data: Collection of featured tender models.
--}}
@php
    $sectionTitle = $content['title'] ?? 'Featured Tenders';
    $bgColor = $content['bg_color'] ?? 'bg-white dark:bg-slate-900';
    $textColor = $content['text_color'] ?? 'text-gray-800 dark:text-gray-100';
    $itemsToShow = (int) ($content['items_to_show'] ?? 3);
    $viewAllLink = $content['view_all_link'] ?? route('landingpage.tenders.index');
    $tenders = $featured_tenders_data ?? collect();
@endphp

<section class="py-12 md:py-16 {{ $bgColor }}">
    <div class="container mx-auto px-4 sm:px-6 lg:px-8">
        <h2 class="text-3xl font-bold text-center mb-2 {{ $textColor }}">{{ $sectionTitle }}</h2>
        @if(!empty($content['subtitle']))
            <p class="text-lg text-center text-gray-600 dark:text-gray-400 mb-10 max-w-2xl mx-auto">{{ $content['subtitle'] }}</p>
        @else
            <div class="mb-10"></div>
        @endif

        @if($tenders->isNotEmpty())
            <div class="space-y-6 max-w-3xl mx-auto">
                @foreach($tenders->take($itemsToShow) as $tender)
                    <div class="bg-white dark:bg-slate-800 p-6 rounded-lg shadow-lg hover:shadow-xl transition-shadow duration-300">
                        <div class="flex flex-col sm:flex-row justify-between items-start sm:items-center">
                            <div>
                                <h3 class="text-xl font-semibold {{ $textColor }} hover:text-purple-600 dark:hover:text-purple-400">
                                    <a href="{{ route('theme.tender.show', $tender->slug) }}">{{ $tender->title }}</a>
                                </h3>
                                <p class="text-sm text-gray-500 dark:text-gray-400">
                                    @if($tender->company) <a href="{{ route('theme.company.show', $tender->company->slug) }}" class="hover:underline">{{ $tender->company->name }}</a> - @endif
                                    Deadline: {{ $tender->deadline ? $tender->deadline->format('M d, Y') : 'N/A' }}
                                </p>
                            </div>
                            <a href="{{ route('theme.tender.show', $tender->slug) }}" class="mt-3 sm:mt-0 inline-block bg-purple-100 dark:bg-purple-700/50 text-purple-700 dark:text-purple-300 hover:bg-purple-200 dark:hover:bg-purple-600/50 font-semibold py-2 px-4 rounded-md text-sm transition-colors">View Tender</a>
                        </div>
                    </div>
                @endforeach
            </div>
            @if($viewAllLink && $tenders->count() > $itemsToShow)
                <div class="text-center mt-10">
                    <a href="{{ $viewAllLink }}" class="inline-block bg-purple-600 hover:bg-purple-700 text-white font-semibold py-3 px-8 rounded-lg text-md shadow-md hover:shadow-lg transition-all duration-300">View All Tenders</a>
                </div>
            @endif
        @else
            <p class="text-center text-gray-500 dark:text-gray-400">No featured tenders to display at the moment.</p>
        @endif
    </div>
</section>