{{--
    Expects:
    - $content: array of section settings (e.g., title, subtitle, bg_color, text_color, items_to_show, view_all_link)
    - $featured_companies_data: Collection of featured company models.
      (This data would be fetched by the controller/service rendering the LpPage and its sections)
--}}
@php
    $sectionTitle = $content['title'] ?? 'Featured Companies';
    $bgColor = $content['bg_color'] ?? 'bg-slate-50 dark:bg-slate-800/50';
    $textColor = $content['text_color'] ?? 'text-gray-800 dark:text-gray-100';
    $itemsToShow = (int) ($content['items_to_show'] ?? 4);
    $viewAllLink = $content['view_all_link'] ?? route('landingpage.companies.index'); // Default to general companies page
    $companies = $featured_companies_data ?? collect(); // Ensure it's a collection
@endphp

<section class="py-12 md:py-16 {{ $bgColor }}">
    <div class="container mx-auto px-4 sm:px-6 lg:px-8">
        <h2 class="text-3xl font-bold text-center mb-2 {{ $textColor }}">{{ $sectionTitle }}</h2>
        @if(!empty($content['subtitle']))
            <p class="text-lg text-center text-gray-600 dark:text-gray-400 mb-10 max-w-2xl mx-auto">{{ $content['subtitle'] }}</p>
        @else
            <div class="mb-10"></div> {{-- Ensure consistent spacing if no subtitle --}}
        @endif

        @if($companies->isNotEmpty())
            <div class="grid grid-cols-1 sm:grid-cols-2 lg:grid-cols-4 gap-6">
                @foreach($companies->take($itemsToShow) as $company)
                    <div class="bg-white dark:bg-slate-800 rounded-lg shadow-lg overflow-hidden hover:shadow-xl transition-shadow duration-300 flex flex-col">
                        <a href="{{ route('theme.company.show', $company->slug) }}" class="block">
                            <img src="{{ $company->banner_url ?? $company->logo_url ?? asset('modules/landingpage/images/placeholder-company.png') }}" alt="{{ $company->name }} banner or logo" class="w-full h-40 object-cover">
                        </a>
                        <div class="p-5 flex flex-col flex-grow">
                            <h3 class="text-lg font-semibold {{ $textColor }} hover:text-purple-600 dark:hover:text-purple-400 leading-tight mb-1">
                                <a href="{{ route('theme.company.show', $company->slug) }}">{{ Str::limit($company->name, 40) }}</a>
                            </h3>
                            @if($company->companyType)
                                <p class="text-xs text-purple-600 dark:text-purple-400 font-medium mb-2 uppercase tracking-wider">{{ $company->companyType->name }}</p>
                            @endif
                            <p class="text-sm text-gray-600 dark:text-gray-400 flex-grow">{{ Str::limit(strip_tags($company->description), 70) }}</p>
                        </div>
                    </div>
                @endforeach
            </div>
            @if($viewAllLink && $companies->count() > $itemsToShow)
                <div class="text-center mt-10">
                    <a href="{{ $viewAllLink }}" class="inline-block bg-purple-600 hover:bg-purple-700 text-white font-semibold py-3 px-8 rounded-lg text-md shadow-md hover:shadow-lg transition-all duration-300">View All Companies</a>
                </div>
            @endif
        @else
            <p class="text-center text-gray-500 dark:text-gray-400">No featured companies to display at the moment.</p>
        @endif
    </div>
</section>