{{-- resources/views/themes/general/sections/featured-projects.blade.php --}}
@php
    $sectionTitle = $section->title ?? 'Featured Projects';
    $projectIdentifiers = $section->content['projects'] ?? []; // Expects an array of slugs or IDs
    $projects = collect(); // Initialize an empty collection

    if (!empty($projectIdentifiers)) {
        // Assuming projects are also LpPage entries for now.
        // Replace with your actual Project model if you have one.
        $projects = \Modules\LandingPage\Entities\LpPage::whereIn('slug', $projectIdentifiers)
                        ->where('is_published', true)
                        // Add any other conditions, e.g., ->where('page_type', 'project')
                        ->orderBy('sort_order')
                        ->take($section->content['limit'] ?? 3) // Allow setting a limit via section content
                        ->get();
    }
@endphp

<section class="py-16 bg-gray-100 dark:bg-gray-800">
    <div class="container mx-auto px-4 sm:px-6 lg:px-8">
        <h2 class="text-3xl font-bold text-center text-gray-800 dark:text-white mb-12">
            {{ $sectionTitle }}
        </h2>
        @if($projects->count() > 0)
        <!-- Swiper -->
        <div class="swiper projects-swiper">
            <div class="swiper-wrapper">
                @foreach ($projects as $project)
                    <div class="swiper-slide h-auto p-2">
                        <div class="bg-white dark:bg-gray-700 rounded-lg shadow-lg overflow-hidden hover:shadow-xl transition-shadow duration-300 h-full flex flex-col">
                            <a href="{{ route('landingpage.page.show', $project->slug) }}" class="block">
                                <img src="{{ $project->featured_image_url ?? 'https://via.placeholder.com/600x400.png?text=Project+Image' }}" alt="{{ $project->title }}" class="w-full h-56 object-cover">
                            </a>
                            <div class="p-6 md:p-8 flex-grow flex flex-col">
                                <h3 class="text-xl font-semibold text-gray-900 dark:text-gray-100 mb-3">{{ $project->title }}</h3>
                                <p class="text-gray-600 dark:text-gray-300 text-sm leading-relaxed line-clamp-3 flex-grow">
                                    {{ $project->meta_description ?? \Illuminate\Support\Str::limit(strip_tags($project->content), 120) }}
                                </p>
                                <a href="{{ route('landingpage.page.show', $project->slug) }}" class="text-purple-600 hover:text-purple-700 dark:text-purple-400 dark:hover:text-purple-300 font-medium mt-4 inline-block self-start">
                                    View Project &rarr;
                                </a>
                            </div>
                        </div>
                    </div>
                @endforeach
            </div>
            <!-- Add Pagination -->
            <div class="swiper-pagination relative pt-8"></div>
            <!-- Add Navigation -->
            <div class="swiper-button-next text-purple-600 dark:text-purple-400"></div>
            <div class="swiper-button-prev text-purple-600 dark:text-purple-400"></div>
        </div>
        @else
            <p class="text-center text-gray-600 dark:text-gray-400">No featured projects to display at the moment.</p>
        @endif
    </div>
</section>

@pushOnce('styles')
    <link rel="stylesheet" href="https://unpkg.com/swiper/swiper-bundle.min.css" />
@endPushOnce

@pushOnce('scripts')
    <script src="https://unpkg.com/swiper/swiper-bundle.min.js"></script>
    <script>
        document.addEventListener('DOMContentLoaded', function () {
            const projectsSwiper = new Swiper('.projects-swiper', {
                loop: false,
                slidesPerView: 1,
                spaceBetween: 30,
                pagination: { el: '.swiper-pagination', clickable: true },
                navigation: { nextEl: '.swiper-button-next', prevEl: '.swiper-button-prev' },
                breakpoints: {
                    768: { slidesPerView: 2, spaceBetween: 30 },
                    1024: { slidesPerView: 3, spaceBetween: 30 },
                }
            });
        });
    </script>
@endPushOnce