{{-- resources/views/themes/general/sections/contact.blade.php --}}
@php
    $sectionTitle = $section->title ?? 'Get in Touch';
    $description = $section->content['description'] ?? "We're excited to hear about your project. Contact us for a consultation or to discuss how we can help.";
    $buttonText = $section->content['button_text'] ?? 'Contact Us';
    $contactPageSlug = $section->content['contact_page_slug'] ?? 'contact';
@endphp

<section class="py-16 bg-gray-100 dark:bg-gray-800">
    <div class="container mx-auto px-4 sm:px-6 lg:px-8 text-center">
        <h2 class="text-3xl font-bold text-gray-800 dark:text-white mb-6">
            {{ $sectionTitle }}
        </h2>
        <p class="text-lg text-gray-600 dark:text-gray-300 max-w-2xl mx-auto mb-10">
            {{ $description }}
        </p>
        <a href="{{ route('landingpage.page.show', $contactPageSlug) }}" class="inline-block bg-purple-600 hover:bg-purple-700 text-white font-bold py-3 px-8 rounded-lg shadow-md hover:shadow-lg transition duration-300">{{ $buttonText }}</a>
    </div>
</section>