@extends('landingpage::themes.job_board.layouts.master')

@php
    // $products is paginated collection from PublicPageController
    // $pageTitle, $metaDescription, $activeTheme are also available

    $page = (object) [
        'title' => $pageTitle ?? 'Our Products',
        'meta_title' => $pageTitle ?? 'Our Products - ' . setting('site_name'),
        'meta_description' => $metaDescription ?? 'Browse our collection of high-quality products.',
        'meta_keywords' => 'products, marketplace, items, for sale',
        'slug' => 'products'
    ];
@endphp

@section('theme_content')
<div class="bg-slate-50 dark:bg-slate-900 py-12 md:py-16">
    <div class="container mx-auto px-4 sm:px-6 lg:px-8">
        <header class="mb-10 text-center">
            <h1 class="text-4xl font-bold tracking-tight text-slate-900 dark:text-slate-100 sm:text-5xl">
                {{ $page->title }}
            </h1>
            @if($page->meta_description)
            <p class="mt-3 text-lg leading-8 text-slate-600 dark:text-slate-300">
                {{ $page->meta_description }}
            </p>
            @endif
        </header>

        {{-- Search/Filter Bar for Products --}}
        <div class="mb-10 bg-white dark:bg-slate-800 p-6 rounded-lg shadow-md">
            <form action="{{ route('landingpage.products.index') }}" method="GET" class="grid grid-cols-1 md:grid-cols-3 gap-4 items-end">
                <div>
                    <label for="keywords" class="block text-sm font-medium text-slate-700 dark:text-slate-300">Product Name/Keyword</label>
                    <input type="text" name="keywords" id="keywords" value="{{ request('keywords') }}" placeholder="e.g., T-shirt, Software" class="mt-1 block w-full rounded-md border-slate-300 dark:border-slate-600 shadow-sm focus:border-blue-500 focus:ring-blue-500 sm:text-sm dark:bg-slate-700 dark:text-slate-200">
                </div>
                <div>
                    {{-- Placeholder for category or other filters --}}
                </div>
                <button type="submit" class="w-full md:w-auto bg-blue-600 hover:bg-blue-700 text-white font-semibold py-2.5 px-4 rounded-md text-sm shadow-sm transition duration-150">Search Products</button>
            </form>
        </div>

        @if($products->isNotEmpty())
            <div class="grid grid-cols-1 sm:grid-cols-2 md:grid-cols-3 lg:grid-cols-4 gap-6 lg:gap-8">
                @foreach($products as $product)
                    <div class="bg-white dark:bg-slate-800 rounded-lg shadow-lg overflow-hidden group">
                        <a href="{{ route('theme.product.show', $product->slug) }}" class="block">
                            <div class="aspect-w-1 aspect-h-1 w-full overflow-hidden">
                                @if($product->images && !empty($product->images[0]))
                                    <img src="{{ asset('storage/' . $product->images[0]) }}" alt="{{ $product->name }}" class="w-full h-full object-cover object-center group-hover:opacity-75 transition-opacity duration-300">
                                @else
                                    <div class="w-full h-full bg-slate-200 dark:bg-slate-700 flex items-center justify-center text-slate-400">
                                        <i class="fas fa-image fa-2x"></i>
                                    </div>
                                @endif
                            </div>
                            <div class="p-4">
                                <h3 class="text-md font-semibold text-slate-900 dark:text-slate-100 group-hover:text-blue-600 dark:group-hover:text-blue-400 transition-colors truncate" title="{{ $product->name }}">
                                    {{ $product->name }}
                                </h3>
                                @if($product->company)
                                <p class="text-xs text-slate-500 dark:text-slate-400 truncate">By {{ $product->company->name }}</p>
                                @endif
                                <p class="mt-1 text-lg font-medium text-slate-800 dark:text-slate-200">
                                    @if($product->sale_price && $product->sale_price < $product->price)
                                        <span class="text-red-600 dark:text-red-400">${{ number_format($product->sale_price, 2) }}</span>
                                        <span class="ml-2 line-through text-sm text-slate-500 dark:text-slate-400">${{ number_format($product->price, 2) }}</span>
                                    @else
                                        ${{ number_format($product->price, 2) }}
                                    @endif
                                </p>
                            </div>
                        </a>
                    </div>
                @endforeach
            </div>

            <div class="mt-12">
                {{ $products->links('landingpage::themes.job_board.partials.pagination') }}
            </div>
        @else
            <p class="text-center text-slate-500 dark:text-slate-400 text-lg">No products found at the moment. Please check back later.</p>
        @endif
    </div>
</div>
@endsection