@php
    // Fetch the 'primary' menu or a configurable menu for the job board theme
    $menuName = setting('landingpage_job_board_primary_menu', 'primary'); // Example: Make this configurable
    $menu = \Modules\LandingPage\Entities\Menu::where('location', $menuName)->orWhere('name', $menuName)->with('rootItems.children')->first();
@endphp

<nav class="hidden md:flex space-x-8">
    @if($menu && $menu->rootItems->isNotEmpty())
        @foreach($menu->rootItems as $item)
            {{-- Pass the $page variable to the menu item component if it exists --}}
            {{-- The menu item component itself should also handle $page being potentially null --}}
            <x-landingpage::themes.job_board.partials.menu-item-frontend :item="$item" :level="0" :page="$page ?? null" />
        @endforeach
    @else
        {{-- Fallback links if menu not found --}}
        <a href="{{ url('/jobs') }}" class="text-sm font-medium text-slate-700 dark:text-slate-200 hover:text-blue-600 dark:hover:text-blue-400">Jobs</a>
        <a href="{{ url('/companies') }}" class="text-sm font-medium text-slate-700 dark:text-slate-200 hover:text-blue-600 dark:hover:text-blue-400">Companies</a>
    @endif

    {{-- Additional action links for authenticated users --}}
    @auth
        <a href="{{ route('frontend.businessdirectory.my-companies.create') }}"
           class="text-sm font-medium text-slate-700 dark:text-slate-200 hover:text-blue-600 dark:hover:text-blue-400">
           List Company
        </a>
        <a href="{{ route('frontend.businessdirectory.my-products.create') }}" {{-- Ensure this route is defined --}}
           class="text-sm font-medium text-slate-700 dark:text-slate-200 hover:text-blue-600 dark:hover:text-blue-400">
           Post Product
        </a>
        <a href="{{ route('frontend.businessdirectory.my-tenders.create') }}" {{-- Ensure this route is defined --}}
           class="text-sm font-medium text-slate-700 dark:text-slate-200 hover:text-blue-600 dark:hover:text-blue-400">
           Post Tender
        </a>
    @endauth
</nav>