<header class="bg-white dark:bg-slate-800 shadow-md sticky top-0 z-40">
    <div class="container mx-auto px-4 sm:px-6 lg:px-8">
        <div class="flex items-center justify-between h-16">
            {{-- Logo --}}
            <div class="flex-shrink-0">
                <a href="{{ url('/') }}" class="text-2xl font-bold text-blue-600 dark:text-blue-400">
                    @if(setting('site_logo'))
                        <img src="{{ asset('storage/' . setting('site_logo')) }}" alt="{{ setting('site_name', 'Job Board') }}" class="h-10">
                    @else
                        {{ setting('site_name', 'JobBoard') }}
                    @endif
                </a>
            </div>

            {{-- Navigation --}}
            @include('landingpage::themes.job_board.partials.navigation', ['page' => $page ?? null])

            {{-- Action Buttons (e.g., Post a Job, Login) --}}
            <div class="hidden md:flex items-center space-x-3">
                <a href="{{ route('login') }}" class="text-sm font-medium text-slate-600 dark:text-slate-300 hover:text-blue-600 dark:hover:text-blue-400">Login</a>
                <a href="#" {{-- Link to Post a Job page --}}
                   class="px-4 py-2 bg-blue-600 border border-transparent rounded-md text-sm font-medium text-white hover:bg-blue-700 focus:outline-none focus:ring-2 focus:ring-offset-2 focus:ring-blue-500">
                    Post a Job
                </a>
            </div>
        </div>
    </div>
</header>