@extends('landingpage::themes.job_board.layouts.master')

@php
    // $newsItems is paginated collection from PublicPageController (assuming it's LpPage for now)
    // $pageTitle, $metaDescription, $activeTheme are also available

    $page = (object) [
        'title' => $pageTitle ?? 'Latest News',
        'meta_title' => $pageTitle ?? 'Latest News - ' . setting('site_name'),
        'meta_description' => $metaDescription ?? 'Stay updated with our latest news and articles.',
        'meta_keywords' => 'news, articles, updates, blog',
        'slug' => 'news'
    ];
@endphp

@section('theme_content')
<div class="bg-slate-50 dark:bg-slate-900 py-12 md:py-16">
    <div class="container mx-auto px-4 sm:px-6 lg:px-8">
        <header class="mb-10 text-center">
            <h1 class="text-4xl font-bold tracking-tight text-slate-900 dark:text-slate-100 sm:text-5xl">
                {{ $page->title }}
            </h1>
            @if($page->meta_description)
            <p class="mt-3 text-lg leading-8 text-slate-600 dark:text-slate-300">
                {{ $page->meta_description }}
            </p>
            @endif
        </header>

        {{-- Search/Filter Bar for News --}}
        <div class="mb-10 bg-white dark:bg-slate-800 p-6 rounded-lg shadow-md">
            <form action="{{ route('landingpage.news.index') }}" method="GET" class="grid grid-cols-1 md:grid-cols-3 gap-4 items-end">
                <div>
                    <label for="keywords" class="block text-sm font-medium text-slate-700 dark:text-slate-300">Search News</label>
                    <input type="text" name="keywords" id="keywords" value="{{ request('keywords') }}" placeholder="e.g., Technology, Updates" class="mt-1 block w-full rounded-md border-slate-300 dark:border-slate-600 shadow-sm focus:border-blue-500 focus:ring-blue-500 sm:text-sm dark:bg-slate-700 dark:text-slate-200">
                </div>
                <div></div> {{-- Placeholder for more filters if needed --}}
                <button type="submit" class="w-full md:w-auto bg-blue-600 hover:bg-blue-700 text-white font-semibold py-2.5 px-4 rounded-md text-sm shadow-sm transition duration-150">Search News</button>
            </form>
        </div>

        @if($newsItems->isNotEmpty())
            <div class="grid grid-cols-1 md:grid-cols-2 lg:grid-cols-3 gap-6 lg:gap-8">
                @foreach($newsItems as $news)
                    <article class="bg-white dark:bg-slate-800 rounded-lg shadow-lg overflow-hidden hover:shadow-xl transition-shadow duration-300 ease-in-out flex flex-col">
                        {{-- You might add an image here if your news items have one --}}
                        {{-- @if($news->featured_image)
                            <a href="{{ route('theme.news.show', $news->slug) }}">
                                <img src="{{ asset('storage/' . $news->featured_image) }}" alt="{{ $news->title }}" class="w-full h-48 object-cover">
                            </a>
                        @endif --}}
                        <div class="p-6 flex flex-col flex-grow">
                            <h2 class="text-xl font-semibold text-slate-900 dark:text-slate-100 mb-2">
                                <a href="{{ route('theme.news.show', $news->slug) }}" class="hover:text-blue-600 dark:hover:text-blue-400 transition-colors">
                                    {{ $news->title }}
                                </a>
                            </h2>
                            <p class="text-sm text-slate-500 dark:text-slate-400 mb-3">
                                <i class="fas fa-calendar-alt mr-1"></i> {{ $news->created_at->format('M d, Y') }}
                            </p>
                            <div class="text-slate-600 dark:text-slate-300 text-sm mb-4 flex-grow">
                                {{ Str::limit(strip_tags($news->content), 150) }} {{-- Assuming content is in LpPage for now --}}
                            </div>
                            <a href="{{ route('theme.news.show', $news->slug) }}" class="mt-auto inline-block text-sm font-medium text-blue-600 dark:text-blue-400 hover:text-blue-700 dark:hover:text-blue-300">
                                Read More <i class="fas fa-arrow-right ml-1"></i>
                            </a>
                        </div>
                    </article>
                @endforeach
            </div>

            <div class="mt-12">
                {{ $newsItems->links('landingpage::themes.job_board.partials.pagination') }}
            </div>
        @else
            <p class="text-center text-slate-500 dark:text-slate-400 text-lg">No news articles found at the moment. Please check back later.</p>
        @endif
    </div>
</div>
@endsection