@extends("landingpage::themes.{$activeTheme}.layouts.app")

@php
    // $page is the LpPage for 'home'
    $siteName = setting('site_name', 'Digital Vocano');
    $heroTitle = $page->hero_title ?? $page->title ?? "Expert Freelance Services & Digital Products";
    // For hero subtitle, you might have a dedicated field or take an excerpt from content
    $heroSubtitle = $page->hero_subtitle ?? \Illuminate\Support\Str::limit(strip_tags($page->content ?? 'Innovative solutions for your web and mobile needs. High-quality Laravel modules, scripts, and custom development services.'), 150);
    $heroCtaText = $page->hero_cta_text ?? 'View Our Portfolio';
    $projectsListingPage = \Modules\LandingPage\Entities\LpPage::where('slug', 'projects')->where('is_published', true)->first();
    $heroCtaLink = $page->hero_cta_link ?? ($projectsListingPage ? route('landingpage.page.show', $projectsListingPage->slug) : '#_');


    // Fetch Featured Projects (LpPage entries)
    // To identify projects, we'll assume they use the 'project_detail' theme_template
    // Or you could have a setting for featured project slugs, or a category/tag system later
    $featuredProjects = \Modules\LandingPage\Entities\LpPage::where('is_published', true)
                        // ->where('theme_template', 'project_detail') // Option 1: by template
                        ->whereIn('slug', ['project-alpha', 'project-beta', 'project-gamma']) // Option 2: by specific slugs (UPDATE THESE with actual project slugs)
                        ->orderBy('sort_order')
                        ->take(3)
                        ->get();
    if ($featuredProjects->isEmpty()) {
        // Fallback if specific project slugs aren't found, get any 3 published non-core pages
        $featuredProjects = \Modules\LandingPage\Entities\LpPage::where('is_published', true)
            ->whereNotIn('slug', ['home', 'about-us', 'services', 'contact', 'privacy-policy', 'terms-of-service'])
            ->orderBy('sort_order')
            ->take(3)
            ->get();
    }


    // Define Services - for a world-class page, these should be distinct items.
    // For now, we'll hardcode a few examples. Ideally, these would come from LpPages, a dedicated Services module, or settings.
    $servicesLpPage = \Modules\LandingPage\Entities\LpPage::where('slug', 'services')->where('is_published', true)->first();
    $services = [
        [
            'title' => 'Custom Web Application Development',
            'description' => 'Bespoke web solutions tailored to your business needs, built with modern technologies like Laravel, Vue.js, and React.',
            'iconSvg' => '<svg class="w-10 h-10" fill="none" stroke="currentColor" viewBox="0 0 24 24" xmlns="http://www.w3.org/2000/svg"><path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M9.75 17L9 20l-1 1h8l-1-1-.75-3M3 13h18M5 17h14a2 2 0 002-2V5a2 2 0 00-2-2H5a2 2 0 00-2 2v10a2 2 0 002 2z"></path></svg>',
            'link' => ($servicesLpPage ? route('landingpage.page.show', $servicesLpPage->slug) : '#_') . '#custom-development',
        ],
        [
            'title' => 'Laravel Module & Script Sales',
            'description' => 'High-quality, ready-to-use Laravel modules and PHP scripts available on CodeCanyon to kickstart your projects.',
            'iconSvg' => '<svg class="w-10 h-10" fill="none" stroke="currentColor" viewBox="0 0 24 24" xmlns="http://www.w3.org/2000/svg"><path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M10 20l4-16m4 4l4 4-4 4M6 16l-4-4 4-4"></path></svg>',
            'link' => setting('codecanyon_profile_url', '#_'), // Replace with your actual CodeCanyon profile URL or use a setting
        ],
        [
            'title' => 'API Integration & Development',
            'description' => 'Seamlessly connect your applications with third-party services or build robust APIs for your own platforms.',
            'iconSvg' => '<svg class="w-10 h-10" fill="none" stroke="currentColor" viewBox="0 0 24 24" xmlns="http://www.w3.org/2000/svg"><path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M13 10V3L4 14h7v7l9-11h-7z"></path></svg>',
            'link' => ($servicesLpPage ? route('landingpage.page.show', $servicesLpPage->slug) : '#_') . '#api-integration',
        ],
    ];

    // Define Technology Stack - replace with your actual stack and logo URLs
    // Store logos in `public/modules/landingpage/themes/general/img/tech/` and publish assets
    $techStack = [
        ['name' => 'Laravel', 'imageUrl' => asset('modules/landingpage/themes/general/img/tech/laravel.svg')],
        ['name' => 'PHP', 'imageUrl' => asset('modules/landingpage/themes/general/img/tech/php.svg')],
        ['name' => 'Vue.js', 'imageUrl' => asset('modules/landingpage/themes/general/img/tech/vue.svg')],
        ['name' => 'Tailwind CSS', 'imageUrl' => asset('modules/landingpage/themes/general/img/tech/tailwind.svg')],
        ['name' => 'MySQL', 'imageUrl' => asset('modules/landingpage/themes/general/img/tech/mysql.svg')],
        ['name' => 'Alpine.js', 'imageUrl' => asset('modules/landingpage/themes/general/img/tech/alpinejs.svg')],
        // Add more...
    ];

    $contactPage = \Modules\LandingPage\Entities\LpPage::where('slug', 'contact')->where('is_published', true)->first();

    // Prepare sameAs URLs for JSON-LD, filtering out empty ones
    $sameAsUrls = [];
    if (setting('social_linkedin_url')) $sameAsUrls[] = '"' . e(setting('social_linkedin_url')) . '"';
    if (setting('social_github_url')) $sameAsUrls[] = '"' . e(setting('social_github_url')) . '"';
    if (setting('social_twitter_url')) $sameAsUrls[] = '"' . e(setting('social_twitter_url')) . '"';
    if (setting('codecanyon_profile_url')) $sameAsUrls[] = '"' . e(setting('codecanyon_profile_url')) . '"';

@endphp

@section('meta_title', $page->meta_title ?? $heroTitle)
@section('meta_description', $page->meta_description ?? setting('landingpage_global_meta_description', 'Expert freelance services for web development, Laravel modules, and custom digital solutions.'))
@section('meta_keywords', $page->meta_keywords ?? setting('landingpage_global_meta_keywords', 'laravel development, php scripts, codecanyon, freelance web developer, custom software'))

@push('schema_markup')
<script type="application/ld+json">
{
  "@context": "https://schema.org",
  "@type": "ProfessionalService",
  "name": "{{ e($siteName) }}",
  "description": "{{ e($page->meta_description ?? setting('landingpage_global_meta_description', 'Expert freelance services for web development, Laravel modules, and custom digital solutions.')) }}",
  "url": "{{ url()->current() }}",
  @if(setting('site_logo') && \Illuminate\Support\Facades\Storage::disk('public')->exists(str_replace(\Illuminate\Support\Facades\Storage::url(''), '', setting('site_logo'))))
  "logo": "{{ \Illuminate\Support\Facades\Storage::url(setting('site_logo')) }}",
  @endif
  "image": "{{ \Illuminate\Support\Facades\Storage::url(setting('site_og_image') ?? (setting('site_logo') ?? '')) }}",
  @if(setting('contact_phone'))"telephone": "{{ e(setting('contact_phone')) }}",@endif
  @if(setting('contact_email'))"email": "{{ e(setting('contact_email')) }}",@endif
  "priceRange": "$$-$$$", {{-- Example: Update with your typical project price range --}}
  "areaServed": {
    "@type": "AdministrativeArea",
    "name": "Worldwide" {{-- Or be more specific if needed, e.g., "United States", "Europe" --}}
  },
  "hasOfferCatalog": {
    "@type": "OfferCatalog",
    "name": "Services and Products",
    "itemListElement": [
      @foreach($services as $service)
      {
        "@type": "Offer",
        "itemOffered": {
          "@type": "Service",
          "name": "{{ e($service['title']) }}",
          "description": "{{ e($service['description']) }}"
        }
      } @if(!$loop->last || $featuredProjects->count() > 0),@endif
      @endforeach
      @foreach($featuredProjects as $project)
      {
        "@type": "Offer",
        "itemOffered": {
          "@type": "SoftwareApplication", {{-- Assuming projects are software/scripts --}}
          "name": "{{ e($project->name ?? $project->title) }}",
          "description": "{{ e($project->short_description ?? \Illuminate\Support\Str::limit(strip_tags($project->content ?? ''), 100)) }}"
          @if($project->canyon_url ?? null)
          ,"offers": {
            "@type": "Offer",
            "url": "{{ e($project->canyon_url) }}"
          }
          @endif
        }
      } @if(!$loop->last),@endif
      @endforeach
    ]
  }
  @if(!empty($sameAsUrls))
  ,"sameAs": [ {!! implode(',', $sameAsUrls) !!} ]
  @endif
}
</script>
@endpush

@push('styles')
<style>
    /* Animation Delays */
    .animation-delay-200 { animation-delay: 0.2s; }
    .animation-delay-400 { animation-delay: 0.4s; }
    .animate-fade-in-down {
        animation: fadeInDown 0.8s ease-out forwards;
        opacity: 0;
    }
    .animate-fade-in-up {
        animation: fadeInUp 0.8s ease-out forwards;
        opacity: 0;
    }
    /* Keyframes for Animations */
    @keyframes fadeInDown {
        from { opacity: 0; transform: translateY(-25px); }
        to   { opacity: 1; transform: translateY(0); }
    }
    @keyframes fadeInUp {
        from { opacity: 0; transform: translateY(25px); }
        to   { opacity: 1; transform: translateY(0); }
    }
    /* Prose Link Styling for Dark Mode */
    .prose-invert a { color: #a78bfa; } /* Tailwind purple-400 for dark mode prose links */
    .prose-invert a:hover { color: #c4b5fd; } /* Tailwind purple-300 for dark mode prose links hover */
</style>
@endpush


{{-- This section renders content based on the LpPage->sections relationship --}}
@section('content')
    @if($page->sections->count() > 0)
        @foreach($page->sections as $section)
            <x-landingpage::landing-page-section :section="$section" :activeTheme="$activeTheme" />
        @endforeach
    @else
        {{-- Fallback content if no sections are defined for the page --}}
        {{-- For the homepage, we'll render the hardcoded sections as a default experience --}}
        {{-- Hero Section (Fallback) --}}
        <section class="relative bg-gradient-to-br from-purple-600 via-indigo-700 to-pink-600 dark:from-purple-700 dark:via-indigo-800 dark:to-pink-700 text-white min-h-[70vh] md:min-h-[80vh] flex items-center justify-center text-center overflow-hidden" aria-labelledby="hero-title-heading">
            <div class="absolute inset-0 bg-black opacity-30"></div>
            <div class="container mx-auto px-4 sm:px-6 lg:px-8 py-24 md:py-32 relative z-10">
                <h1 id="hero-title-heading" class="text-4xl sm:text-5xl md:text-6xl lg:text-7xl font-extrabold mb-6 leading-tight animate-fade-in-down">
                    {{ $heroTitle }}
                </h1>
                <p class="text-lg md:text-xl lg:text-2xl mb-10 max-w-3xl mx-auto text-gray-200 dark:text-gray-300 animate-fade-in-up animation-delay-200">
                     {{ $heroSubtitle }}
                </p>
                <div class="animate-fade-in-up animation-delay-400 space-y-4 sm:space-y-0 sm:flex sm:justify-center sm:space-x-4">
                    @if($heroCtaLink && $heroCtaLink !== '#_')
                    <a href="{{ $heroCtaLink }}" class="inline-block bg-yellow-400 hover:bg-yellow-500 text-gray-900 font-bold py-3 px-10 rounded-lg text-lg shadow-xl transform hover:scale-105 transition-all duration-300 ease-in-out">
                        {{ $heroCtaText }}
                    &lt;/a&gt;
                    @endif
                    @if($contactPage)
                    <a href="{{ route('landingpage.page.show', $contactPage->slug) }}" class="inline-block border-2 border-gray-300 hover:bg-gray-100 hover:text-purple-700 text-white font-bold py-3 px-10 rounded-lg text-lg shadow-xl transform hover:scale-105 transition-all duration-300 ease-in-out">
                        Contact Us
                    &lt;/a&gt;
                    @endif
                &lt;/div&gt;
            &lt;/div&gt;
        &lt;/section&gt;

        {{-- Services/Features Section (Fallback) --}}
        <section id="services" class="py-16 md:py-24 bg-white dark:bg-gray-900" aria-labelledby="services-heading">
            &lt;div class="container mx-auto px-4 sm:px-6 lg:px-8"&gt;
                &lt;div class="text-center mb-12 md:mb-16"&gt;
                    <h2 id="services-heading" class="text-3xl md:text-4xl font-bold text-gray-800 dark:text-white">Our Core Services</h2>
                    <p class="mt-4 text-lg text-gray-600 dark:text-gray-400 max-w-2xl mx-auto">Delivering high-impact digital solutions to elevate your business.</p>
                &lt;/div&gt;
                &lt;div class="grid grid-cols-1 md:grid-cols-2 lg:grid-cols-3 gap-8"&gt;
                    @foreach($services as $service)
                        <x-landingpage::themes.general.service-item
                            :title="$service['title']"
                            :description="$service['description']"
                            :iconSvg="$service['iconSvg']"
                        />
                    @endforeach
                &lt;/div&gt;
            &lt;/div&gt;
        &lt;/section&gt;

        {{-- Featured Projects Section (Fallback) --}}
        @if($featuredProjects->count() > 0)
        <section id="projects" class="py-16 md:py-24 bg-gray-100 dark:bg-gray-800/70" aria-labelledby="projects-heading">
            &lt;div class="container mx-auto px-4 sm:px-6 lg:px-8"&gt;
                &lt;div class="text-center mb-12 md:mb-16"&gt;
                    <h2 id="projects-heading" class="text-3xl md:text-4xl font-bold text-gray-800 dark:text-white">Featured Projects & Products</h2>
                    <p class="mt-4 text-lg text-gray-600 dark:text-gray-400 max-w-2xl mx-auto">Discover our latest creations and successful digital solutions available on CodeCanyon.</p>
                &lt;/div&gt;
                &lt;div class="grid grid-cols-1 md:grid-cols-2 lg:grid-cols-3 gap-8 md:gap-12"&gt;
                    @foreach ($featuredProjects as $project)
                        <x-landingpage::themes.general.project-card :project="$project" canyonLink="{{ $project->canyon_url ?? null }}" />
                    @endforeach
                &lt;/div&gt;
                @if($projectsListingPage)
                <div class="text-center mt-12 md:mt-16">
                    <a href="{{ route('landingpage.page.show', $projectsListingPage->slug) }}" class="inline-block bg-purple-600 hover:bg-purple-700 text-white font-semibold py-3 px-8 rounded-lg text-lg shadow-md hover:shadow-lg transition-all duration-300">
                        View All Projects & Products
                    &lt;/a&gt;
                &lt;/div&gt;
                @endif
            &lt;/div&gt;
        &lt;/section&gt;
        @endif

        {{-- Technology Stack Section (Fallback) --}}
        <section id="tech-stack" class="py-16 md:py-24 bg-white dark:bg-gray-900" aria-labelledby="tech-stack-heading">
            <div class="container mx-auto px-4 sm:px-6 lg:px-8">
                <div class="text-center mb-12 md:mb-16">
                    <h2 id="tech-stack-heading" class="text-3xl md:text-4xl font-bold text-gray-800 dark:text-white">Our Technology Expertise</h2>
                    <p class="mt-4 text-lg text-gray-600 dark:text-gray-400 max-w-2xl mx-auto">Leveraging cutting-edge tools and frameworks to build robust and scalable solutions.</p>
                </div>
                <div class="grid grid-cols-2 sm:grid-cols-3 md:grid-cols-4 lg:grid-cols-6 gap-6 md:gap-8">
                    @foreach($techStack as $tech)
                        <x-landingpage::themes.general.tech-stack-icon :name="$tech['name']" :imageUrl="$tech['imageUrl']" />
                    @endforeach
                </div>
            </div>
        </section>

        {{-- Call to Action Section (Fallback) --}}
        <section class="py-16 md:py-24 bg-gradient-to-r from-purple-600 via-indigo-600 to-pink-500 dark:from-purple-700 dark:via-indigo-700 dark:to-pink-600 text-white" aria-labelledby="cta-heading">
            <div class="container mx-auto px-4 sm:px-6 lg:px-8 text-center">
                <h2 id="cta-heading" class="text-3xl md:text-4xl lg:text-5xl font-bold mb-6">Ready to Elevate Your Digital Presence?</h2>
                <p class="text-lg md:text-xl text-purple-100 dark:text-indigo-200 mb-10 max-w-2xl mx-auto">Partner with Digital Vocano to bring your vision to life. Let's discuss your project requirements and how we can help you succeed.</p>
                @if($contactPage)
                <a href="{{ route('landingpage.page.show', $contactPage->slug) }}" class="bg-yellow-400 hover:bg-yellow-500 text-gray-900 font-bold py-4 px-10 rounded-lg text-lg shadow-xl transform hover:scale-105 transition-all duration-300 ease-in-out">
                    Get a Free Quote
                &lt;/a&gt;
                @endif
            </div>
        </section>
    @endif
@endsection
