@extends('landingpage::themes.job_board.layouts.master')

@php
    // $companies is paginated collection from PublicPageController
    // $pageTitle, $metaDescription, $activeTheme are also available

    $page = (object) [
        'title' => $pageTitle ?? 'Company Directory',
        'meta_title' => $pageTitle ?? 'Company Directory - ' . setting('site_name'),
        'meta_description' => $metaDescription ?? 'Browse our directory of registered companies.',
        'meta_keywords' => 'companies, businesses, directory, employers',
        'slug' => 'companies'
    ];
@endphp

@section('theme_content')
<div class="bg-slate-50 dark:bg-slate-900 py-12 md:py-16">
    <div class="container mx-auto px-4 sm:px-6 lg:px-8">
        <header class="mb-10 text-center">
            <h1 class="text-4xl font-bold tracking-tight text-slate-900 dark:text-slate-100 sm:text-5xl">
                {{ $page->title }}
            </h1>
            @if($page->meta_description)
            <p class="mt-3 text-lg leading-8 text-slate-600 dark:text-slate-300">
                {{ $page->meta_description }}
            </p>
            @endif
        </header>

        {{-- Search/Filter Bar for Companies --}}
        <div class="mb-10 bg-white dark:bg-slate-800 p-6 rounded-lg shadow-md">
            <form action="{{ route('landingpage.companies.index') }}" method="GET" class="grid grid-cols-1 md:grid-cols-3 gap-4 items-end">
                <div>
                    <label for="name" class="block text-sm font-medium text-slate-700 dark:text-slate-300">Company Name</label>
                    <input type="text" name="name" id="name" value="{{ request('name') }}" placeholder="e.g., Acme Corp, Tech Solutions" class="mt-1 block w-full rounded-md border-slate-300 dark:border-slate-600 shadow-sm focus:border-blue-500 focus:ring-blue-500 sm:text-sm dark:bg-slate-700 dark:text-slate-200">
                </div>
                <div>
                    <label for="location" class="block text-sm font-medium text-slate-700 dark:text-slate-300">Location</label>
                    <input type="text" name="location" id="location" value="{{ request('location') }}" placeholder="e.g., London, California" class="mt-1 block w-full rounded-md border-slate-300 dark:border-slate-600 shadow-sm focus:border-blue-500 focus:ring-blue-500 sm:text-sm dark:bg-slate-700 dark:text-slate-200">
                </div>
                <button type="submit" class="w-full md:w-auto bg-blue-600 hover:bg-blue-700 text-white font-semibold py-2.5 px-4 rounded-md text-sm shadow-sm transition duration-150">Search Companies</button>
            </form>
        </div>

        @if($companies->isNotEmpty())
            <div class="grid grid-cols-1 sm:grid-cols-2 lg:grid-cols-3 xl:grid-cols-4 gap-6 lg:gap-8">
                @foreach($companies as $company)
                    <div class="bg-white dark:bg-slate-800 rounded-lg shadow-lg overflow-hidden text-center hover:shadow-xl transition-shadow duration-300 ease-in-out">
                        <a href="{{ route('theme.company.show', $company->slug) }}" class="block p-6">
                            @if($company->logo)
                                <img src="{{ asset('storage/' . $company->logo) }}" alt="{{ $company->name }} Logo" class="w-20 h-20 mx-auto rounded-full object-contain mb-4 border border-slate-200 dark:border-slate-700">
                            @else
                                <div class="w-20 h-20 mx-auto rounded-full bg-slate-200 dark:bg-slate-700 flex items-center justify-center text-slate-500 dark:text-slate-400 text-2xl font-bold mb-4">
                                    {{ strtoupper(substr($company->name, 0, 1)) }}
                                </div>
                            @endif
                            <h2 class="text-lg font-semibold text-slate-900 dark:text-slate-100 mb-1 truncate" title="{{ $company->name }}">
                                {{ $company->name }}
                            </h2>
                            @if($company->city && $company->country)
                                <p class="text-sm text-slate-500 dark:text-slate-400 truncate"><i class="fas fa-map-marker-alt mr-1 text-xs"></i>{{ $company->city }}, {{ $company->country }}</p>
                            @elseif($company->country)
                                <p class="text-sm text-slate-500 dark:text-slate-400 truncate"><i class="fas fa-map-marker-alt mr-1 text-xs"></i>{{ $company->country }}</p>
                            @endif
                            {{-- You can add more info like industry or number of open jobs --}}
                        </a>
                    </div>
                @endforeach
            </div>

            <div class="mt-12">
            {{ $companies->links('vendor.pagination.tailwind') }} {{-- Or just $companies->links() if Tailwind is your default --}}
            </div>
        @else
            <p class="text-center text-slate-500 dark:text-slate-400 text-lg">No companies found in the directory at the moment.</p>
        @endif
    </div>
</div>
@endsection