@extends("landingpage::themes.{$activeTheme}.layouts.app")

@section('meta_title', $pageTitle ?? 'Current Tenders')
@section('meta_description', $metaDescription ?? 'Find and apply for current tender opportunities.')

@section('content')
<div class="bg-gray-50 dark:bg-gray-900 py-12 md:py-20">
    <div class="container mx-auto px-4 sm:px-6 lg:px-8">
        <header class="mb-12 text-center">
            <h1 class="text-4xl font-bold text-gray-800 dark:text-white">{{ $pageTitle ?? 'Tenders' }}</h1>
            @if(isset($metaDescription))
            <p class="mt-4 text-lg text-gray-600 dark:text-gray-300">{{ $metaDescription }}</p>
            @endif
        </header>

        @if($tenders->isNotEmpty())
            <div class="space-y-8 mb-12">
                @foreach($tenders as $tender)
                    <div class="bg-white dark:bg-gray-800 p-6 rounded-lg shadow-lg hover:shadow-xl transition-shadow duration-300">
                        <div class="md:flex md:justify-between md:items-start">
                            <div class="flex-grow mb-4 md:mb-0">
                                <h2 class="text-2xl font-semibold text-[var(--clr-accent)] mb-1">
                                    <a href="{{-- route('module.tenders.show', $tender->slug) --}}#" class="hover:underline">
                                        {{ $tender->title }}
                                    </a>
                                </h2>
                                @if($tender->company)
                                <p class="text-sm text-gray-500 dark:text-gray-400 mb-1">Company: {{ $tender->company->name }}</p>
                                @endif
                                <p class="text-sm text-gray-500 dark:text-gray-400 mb-3">Location: {{ $tender->location ?? 'N/A' }}</p>
                                <p class="text-gray-600 dark:text-gray-300 text-sm">
                                    {{ Str::limit($tender->description ?? 'No description provided.', 200) }}
                                </p>
                            </div>
                            <div class="md:ml-6 md:text-right flex-shrink-0">
                                <p class="text-md text-gray-700 dark:text-gray-200 font-semibold mb-1">
                                    Budget: {{ $tender->currency }} {{ number_format($tender->budget_min,0) }} - {{ number_format($tender->budget_max,0) }}
                                </p>
                                <p class="text-sm text-red-600 dark:text-red-400 font-medium mb-3">
                                    Deadline: {{ $tender->deadline ? $tender->deadline->format('F j, Y, g:i a') : 'Not specified' }}
                                </p>
                                <a href="{{-- route('module.tenders.show', $tender->slug) --}}#" class="inline-block bg-purple-600 hover:bg-purple-700 text-white font-semibold py-2 px-4 rounded-lg transition duration-300 text-sm">
                                    View Details
                                </a>
                            </div>
                        </div>
                    </div>
                @endforeach
            </div>
            {{-- Pagination Links --}}
            <div class="mt-8">
                {{ $tenders->links() }}
            </div>
        @else
            <p class="text-center text-gray-600 dark:text-gray-400 text-xl">No open tenders found at the moment. Please check back later.</p>
        @endif
    </div>
</div>
@endsection