{{-- resources/views/themes/general/sections/testimonials.blade.php --}}
@php
    $sectionTitle = $section->title ?? 'What Our Clients Say';
    // Expects an array of testimonial objects: [['quote' => '', 'author' => '', 'company' => '']]
    $testimonials = $section->content['testimonials_list'] ?? [];
    // Fallback for demonstration if $testimonials is empty (remove for production if not needed)
    // if (empty($testimonials)) {
    //     $testimonials = [
    //         ['quote' => 'Working with Digital Vocano was a game-changer for our business. Their expertise and dedication are unparalleled.', 'author' => 'Jane Doe', 'company' => 'Innovatech Ltd.', 'author_image_url' => 'https://via.placeholder.com/80x80.png?text=JD'],
    //         ['quote' => 'The team delivered an exceptional product on time and within budget. Highly recommended!', 'author' => 'John Smith', 'company' => 'Solutions Inc.'],
    //     ];
    // }
@endphp

<section class="py-16 bg-white dark:bg-gray-900">
    <div class="container mx-auto px-4 sm:px-6 lg:px-8">
        <h2 class="text-3xl font-bold text-center text-gray-800 dark:text-white mb-12">
            {{ $sectionTitle }}
        </h2>
        @if(!empty($testimonials))
        <!-- Swiper -->
        <div class="swiper testimonials-swiper max-w-3xl mx-auto">
            <div class="swiper-wrapper">
                @foreach ($testimonials as $testimonial)
                    <div class="swiper-slide h-auto p-2">
                        <div class="bg-gray-50 dark:bg-gray-800 rounded-lg p-6 md:p-8 shadow-md hover:shadow-lg transition-shadow duration-300 h-full flex flex-col items-center justify-center">
                            @if(!empty($testimonial['author_image_url']))
                                <img src="{{ $testimonial['author_image_url'] }}" alt="{{ $testimonial['author'] }}" class="w-20 h-20 rounded-full mb-4 object-cover">
                            @endif
                            <p class="text-gray-700 dark:text-gray-300 italic text-lg mb-4 text-center">
                                "{{ $testimonial['quote'] }}"
                            </p>
                            <p class="text-gray-800 dark:text-gray-200 text-md font-semibold text-center">
                                - {{ $testimonial['author'] }}{{ isset($testimonial['company']) && !empty($testimonial['company']) ? ', ' . $testimonial['company'] : '' }}
                            </p>
                        </div>
                    </div>
                @endforeach
            </div>
            <!-- Add Pagination -->
            <div class="swiper-pagination relative pt-8"></div>
        </div>
        @else
            <p class="text-center text-gray-600 dark:text-gray-400">Client testimonials will be featured here soon.</p>
        @endif
    </div>
</section>

@pushOnce('styles')
    <link rel="stylesheet" href="https://unpkg.com/swiper/swiper-bundle.min.css" />
@endPushOnce

@pushOnce('scripts')
    <script src="https://unpkg.com/swiper/swiper-bundle.min.js"></script>
    <script>
        document.addEventListener('DOMContentLoaded', function () {
            const testimonialsSwiper = new Swiper('.testimonials-swiper', {
                loop: true,
                slidesPerView: 1,
                spaceBetween: 30,
                autoplay: {
                    delay: 6000,
                    disableOnInteraction: false,
                },
                pagination: {
                    el: '.swiper-pagination',
                    clickable: true,
                },
            });
        });
    </script>
@endPushOnce