@extends("landingpage::themes.{$activeTheme}.layouts.app")

@section('meta_title', $pageTitle ?? 'Business Directory')
@section('meta_description', $metaDescription ?? 'Explore companies in our directory.')

@section('content')
<div class="bg-gray-50 dark:bg-gray-900 py-12 md:py-20">
    <div class="container mx-auto px-4 sm:px-6 lg:px-8">
        <header class="mb-12 text-center">
            <h1 class="text-4xl font-bold text-gray-800 dark:text-white">{{ $pageTitle ?? 'Companies' }}</h1>
            @if(isset($metaDescription))
            <p class="mt-4 text-lg text-gray-600 dark:text-gray-300">{{ $metaDescription }}</p>
            @endif
        </header>

        @if($companies->isNotEmpty())
            <div class="grid grid-cols-1 sm:grid-cols-2 md:grid-cols-3 lg:grid-cols-4 gap-8 mb-12">
                @foreach($companies as $company)
                    <div class="bg-white dark:bg-gray-800 rounded-lg shadow-lg overflow-hidden hover:shadow-xl transition-shadow duration-300 flex flex-col">
                        <a href="{{-- route('module.companies.show', $company->slug) --}}#" class="block p-6 text-center">
                            @if($company->logo)
                                <img src="{{ Storage::url($company->logo) }}" alt="{{ $company->name }} Logo" class="w-28 h-28 object-contain rounded-full mx-auto mb-4 border-2 border-gray-200 dark:border-gray-700 p-1">
                            @else
                                <div class="w-28 h-28 bg-gray-200 dark:bg-gray-700 rounded-full mx-auto mb-4 flex items-center justify-center border-2 border-gray-200 dark:border-gray-700">
                                    <span class="text-gray-500 dark:text-gray-400 text-lg">{{ Str::limit($company->name, 1, '') }}</span>
                                </div>
                            @endif
                        </a>
                        <div class="p-6 pt-0 text-center flex flex-col flex-grow">
                            <h2 class="text-xl font-semibold text-gray-800 dark:text-white mb-1">
                                <a href="{{-- route('module.companies.show', $company->slug) --}}#" class="hover:text-[var(--clr-accent)]">
                                    {{ $company->name }}
                                </a>
                            </h2>
                            <p class="text-gray-600 dark:text-gray-400 text-sm mb-3 flex-grow">
                                {{ Str::limit($company->description ?? 'A leading business in its industry.', 90) }}
                            </p>
                            <a href="{{-- route('module.companies.show', $company->slug) --}}#" class="mt-auto w-full text-center bg-purple-600 hover:bg-purple-700 text-white font-semibold py-2 px-4 rounded-lg transition duration-300 text-sm">
                                View Profile
                            </a>
                        </div>
                    </div>
                @endforeach
            </div>
            {{-- Pagination Links --}}
            <div class="mt-8">
                {{ $companies->links() }}
            </div>
        @else
            <p class="text-center text-gray-600 dark:text-gray-400 text-xl">No companies found in the directory at the moment. Please check back later.</p>
        @endif
    </div>
</div>
@endsection