@php
    // $section is available from the page renderer
    // Default values for section content
    $sectionTitle = $section->content['title'] ?? 'Our Recent Work';
    $numberOfProjects = (int)($section->content['number_of_items'] ?? 3);
    $viewAllLink = $section->content['view_all_link'] ?? null; // e.g., '/portfolio'
    $viewAllText = $section->content['view_all_text'] ?? 'View Full Portfolio';

    // Fetch projects from DigitalVocano module
    try {
        $portfolioProjects = \Modules\DigitalVocano\Entities\Project::query()
            ->where('is_published', true)
            ->orderBy('sort_order', 'asc')
            ->orderBy('created_at', 'desc')
            ->take($numberOfProjects)
            ->get();
    } catch (\Throwable $e) {
        $portfolioProjects = collect();
        \Illuminate\Support\Facades\Log::error("Error fetching DigitalVocano projects for landing page section: " . $e->getMessage());
    }
@endphp

@if($portfolioProjects->isNotEmpty())
<section class="py-12 md:py-20 bg-gray-100 dark:bg-gray-900">
    <div class="container mx-auto px-4 sm:px-6 lg:px-8">
        <h2 class="text-3xl font-bold text-center text-gray-800 dark:text-white mb-10">{{ $sectionTitle }}</h2>
        <div class="grid grid-cols-1 md:grid-cols-2 lg:grid-cols-3 gap-8">
            @foreach($portfolioProjects as $dvProject)
                <div class="bg-white dark:bg-gray-800 rounded-lg shadow-lg overflow-hidden hover:shadow-xl transition-shadow duration-300 flex flex-col">
                    @if($dvProject->featured_image_url)
                        <a href="{{-- route('portfolio.project.show', $dvProject->slug) --}}#"> {{-- Link to detail page --}}
                            <img src="{{ $dvProject->featured_image_url }}" alt="{{ $dvProject->name }}" class="w-full h-56 object-cover">
                        </a>
                    @else
                        <div class="w-full h-56 bg-gray-200 dark:bg-gray-700 flex items-center justify-center">
                            <span class="text-gray-500 dark:text-gray-400">No Image</span>
                        </div>
                    @endif
                    <div class="p-6 flex flex-col flex-grow">
                        <h3 class="text-xl font-semibold text-[var(--clr-accent)] mb-2 flex-grow">
                            <a href="{{-- route('portfolio.project.show', $dvProject->slug) --}}#" class="hover:underline">{{ $dvProject->name }}</a>
                        </h3>
                        <p class="text-gray-600 dark:text-gray-400 text-sm mb-4">{{ Str::limit($dvProject->short_description ?? 'Amazing project.', 100) }}</p>
                        <div class="mt-auto">
                            <a href="{{-- route('portfolio.project.show', $dvProject->slug) --}}#" class="text-purple-500 hover:text-purple-700 dark:hover:text-purple-300 font-medium text-sm">View Project &rarr;</a>
                            @if($dvProject->demo_url)
                                <a href="{{ $dvProject->demo_url }}" target="_blank" class="ml-4 text-green-500 hover:text-green-700 dark:hover:text-green-300 font-medium text-sm">Live Demo &rarr;</a>
                            @endif
                        </div>
                    </div>
                </div>
            @endforeach
        </div>
        @if($viewAllLink)
        <div class="text-center mt-12">
            <a href="{{ url($viewAllLink) }}" class="inline-block bg-purple-600 hover:bg-purple-700 text-white font-semibold py-3 px-8 rounded-lg transition duration-300">
                {{ $viewAllText }}
            </a>
        </div>
        @endif
    </div>
</section>
@endif