{{--
    AI Website Maker "How It Works" Section
    Expects $content to contain:
    - section_title: string (Optional, defaults to "How It Works")
    - section_subtitle: string (Optional)
    - steps: array of objects, each with:
        - icon: string (e.g., SVG path or class for an icon font)
        - title: string
        - description: string
--}}
@php
    $sectionTitle = $content['section_title'] ?? 'How It Works';
    $sectionSubtitle = $content['section_subtitle'] ?? 'Create your dream website in three simple steps.';
    $defaultSteps = [
        [
            'icon' => '<svg aria-hidden="true" xmlns="http://www.w3.org/2000/svg" fill="none" viewBox="0 0 24 24" stroke-width="1.5" stroke="currentColor" class="w-12 h-12 text-primary-500 dark:text-primary-400"><path stroke-linecap="round" stroke-linejoin="round" d="M10.5 6h9.75M10.5 6a1.5 1.5 0 11-3 0m3 0a1.5 1.5 0 10-3 0M3.75 6H7.5m3 12h9.75m-9.75 0a1.5 1.5 0 01-3 0m3 0a1.5 1.5 0 00-3 0m-3.75 0H7.5m9-6h3.75m-3.75 0a1.5 1.5 0 01-3 0m3 0a1.5 1.5 0 00-3 0m-9.75 0h9.75" /></svg>',
            'title' => '1. Describe Your Vision',
            'description' => 'Tell our AI about your business, preferred style, and key features. The more details, the better!',
        ],
        [
            'icon' => '<svg aria-hidden="true" xmlns="http://www.w3.org/2000/svg" fill="none" viewBox="0 0 24 24" stroke-width="1.5" stroke="currentColor" class="w-12 h-12 text-primary-500 dark:text-primary-400"><path stroke-linecap="round" stroke-linejoin="round" d="M9.813 15.904L9 18.75l-.813-2.846a4.5 4.5 0 00-3.09-3.09L2.25 12l2.846-.813a4.5 4.5 0 003.09-3.09L9 5.25l.813 2.846a4.5 4.5 0 003.09 3.09L15.75 12l-2.846.813a4.5 4.5 0 00-3.09 3.09zM18.259 8.715L18 9.75l-.259-1.035a3.375 3.375 0 00-2.455-2.456L14.25 6l1.036-.259a3.375 3.375 0 002.455-2.456L18 2.25l.259 1.035a3.375 3.375 0 002.456 2.456L21.75 6l-1.035.259a3.375 3.375 0 00-2.456 2.456zM16.894 20.567L16.5 21.75l-.394-1.183a2.25 2.25 0 00-1.423-1.423L13.5 18.75l1.183-.394a2.25 2.25 0 001.423-1.423l.394-1.183.394 1.183a2.25 2.25 0 001.423 1.423l1.183.394-1.183.394a2.25 2.25 0 00-1.423 1.423z" /></svg>',
            'title' => '2. AI Crafts Your Site',
            'description' => 'Our intelligent algorithms generate a unique, professional website tailored to your needs in seconds.',
        ],
        [
            'icon' => '<svg aria-hidden="true" xmlns="http://www.w3.org/2000/svg" fill="none" viewBox="0 0 24 24" stroke-width="1.5" stroke="currentColor" class="w-12 h-12 text-primary-500 dark:text-primary-400"><path stroke-linecap="round" stroke-linejoin="round" d="M9 12.75L11.25 15 15 9.75M21 12c0 1.268-.63 2.39-1.593 3.068a3.745 3.745 0 01-1.043 3.296 3.745 3.745 0 01-3.296 1.043A3.745 3.745 0 0112 21c-1.268 0-2.39-.63-3.068-1.593a3.746 3.746 0 01-3.296-1.043 3.745 3.745 0 01-1.043-3.296A3.745 3.745 0 013 12c0-1.268.63-2.39 1.593-3.068a3.745 3.745 0 011.043-3.296 3.746 3.746 0 013.296-1.043A3.746 3.746 0 0112 3c1.268 0 2.39.63 3.068 1.593a3.746 3.746 0 013.296 1.043 3.746 3.746 0 011.043 3.296A3.745 3.745 0 0121 12z" /></svg>',
            'title' => '3. Customize & Launch',
            'description' => 'Fine-tune the design, content, and then download your site or deploy it directly to your cPanel.',
        ],
    ];
    $steps = $content['steps'] ?? $defaultSteps;
@endphp

<section class="py-16 md:py-24 bg-slate-100 dark:bg-slate-800">
    <div class="container mx-auto px-4 sm:px-6 lg:px-8">
        <div class="text-center mb-12 md:mb-16">
            <h2 class="font-lexend text-3xl sm:text-4xl font-bold text-slate-800 dark:text-white mb-3">
                {{ $sectionTitle }}
            </h2>
            @if(!empty($sectionSubtitle))
            <p class="text-lg text-slate-600 dark:text-slate-300 max-w-2xl mx-auto">
                {{ $sectionSubtitle }}
            </p>
            @endif
        </div>

        <div class="grid md:grid-cols-3 gap-8 lg:gap-12">
            @if(is_array($steps) && count($steps) > 0)
                @foreach($steps as $index => $step)
                    <div class="text-center p-6 bg-white dark:bg-slate-800/50 rounded-xl shadow-lg hover:shadow-primary-500/20 dark:hover:shadow-primary-400/20 transition-all duration-300 ease-in-out transform hover:-translate-y-1 hover:scale-[1.02]">
                        <div class="flex justify-center mb-5">
                            <div class="p-3 bg-primary-100 dark:bg-primary-500/20 rounded-full">
                                {!! $step['icon'] ?? '<svg aria-hidden="true" xmlns="http://www.w3.org/2000/svg" fill="none" viewBox="0 0 24 24" stroke-width="1.5" stroke="currentColor" class="w-10 h-10 text-primary-500 dark:text-primary-400"><path stroke-linecap="round" stroke-linejoin="round" d="M4.5 12.75l6 6 9-13.5" /></svg>' !!}
                            </div>
                        </div>
                        <h3 class="font-lexend text-xl font-semibold text-slate-700 dark:text-white mb-2">
                            {{ $step['title'] ?? 'Step ' . ($index + 1) }}
                        </h3>
                        <p class="text-slate-500 dark:text-slate-400 text-sm leading-relaxed">
                            {{ $step['description'] ?? 'Detailed description for this step.' }}
                        </p>
                    </div>
                @endforeach
            @else
                <p class="md:col-span-3 text-center text-slate-500 dark:text-slate-400">Steps will be displayed here once configured.</p>
            @endif
        </div>
    </div>
</section>