{{--
    Available variables:
    $content (array): The content for this section, expected to have a 'slides' array.
    $title (string|null): Optional title for the section (less common for hero).
    $section (LpPageSection instance): The full section object.
--}}

@php
    $slides = data_get($content, 'slides', []);
    $hasSlides = !empty($slides) && is_array($slides) && count($slides) > 0;
@endphp

@if($hasSlides)
    <section class="hero-slider-section relative w-full overflow-hidden" aria-label="Hero Slideshow">
        <!-- Swiper -->
        <div class="swiper hero-swiper">
            <div class="swiper-wrapper">
                @foreach($slides as $index => $slide)
                    @php
                        $slideTitle = data_get($slide, 'title', 'Welcome');
                        $slideSubtitle = data_get($slide, 'subtitle', '');
                        $slideCtaText = data_get($slide, 'cta_text', 'Learn More');
                        $slideCtaLink = data_get($slide, 'cta_link', '#');
                        // Secondary CTA (optional, fields would need to be added in admin form)
                        $slideCtaSecondaryText = data_get($slide, 'cta_secondary_text');
                        $slideCtaSecondaryLink = data_get($slide, 'cta_secondary_link');

                        $imagePath = data_get($slide, 'image_url');
                        // Use Storage::url for uploaded images, asset for theme's default fallback
                        $slideFullImageUrl = $imagePath ? Storage::url($imagePath) : asset('modules/landingpage/images/default-hero-bg.jpg');
                    @endphp
                    <div class="swiper-slide min-h-[70vh] md:min-h-[85vh] flex items-center justify-center text-center bg-cover bg-center relative"
                         style="background-image: url('{{ $slideFullImageUrl }}');">
                        {{-- Dark overlay for better text readability on images --}}
                        <div class="absolute inset-0 bg-black opacity-60"></div>
                        <div class="container mx-auto px-4 sm:px-6 lg:px-8 py-24 md:py-32 text-white relative z-10">
                            <h1 class="text-4xl sm:text-5xl md:text-6xl lg:text-7xl font-extrabold mb-6 leading-tight animate-fade-in-down">
                                {{ $slideTitle }}
                            </h1>
                            @if($slideSubtitle)
                            <p class="text-lg md:text-xl lg:text-2xl mb-10 max-w-3xl mx-auto text-slate-100 dark:text-slate-200 animate-fade-in-up animation-delay-200">
                                {{ $slideSubtitle }}
                            </p>
                            @endif
                            <div class="animate-fade-in-up animation-delay-400 space-y-4 sm:space-y-0 sm:flex sm:flex-wrap sm:justify-center sm:items-center sm:gap-4">
                                @if($slideCtaText && $slideCtaLink)
                                    <a href="{{ $slideCtaLink }}"
                                       class="inline-block bg-[var(--clr-accent)] hover:brightness-110 text-white font-bold py-3 px-10 rounded-lg text-lg shadow-xl transform hover:scale-105 transition-all duration-300 ease-in-out">
                                        {{ $slideCtaText }}
                                    </a>
                                @endif
                                @if($slideCtaSecondaryText && $slideCtaSecondaryLink)
                                    <a href="{{ $slideCtaSecondaryLink }}"
                                       class="inline-block border-2 border-slate-300 hover:bg-slate-100 hover:text-[var(--clr-accent)] text-white font-bold py-3 px-10 rounded-lg text-lg shadow-xl transform hover:scale-105 transition-all duration-300 ease-in-out">
                                        {{ $slideCtaSecondaryText }}
                                    </a>
                                @endif
                            </div>
                        </div>
                    </div>
                @endforeach
            </div>
            <!-- Add Pagination -->
            <div class="swiper-pagination"></div>
            <!-- Add Navigation -->
            <div class="swiper-button-next text-white hover:text-[var(--clr-accent)] transition-colors duration-300"></div>
            <div class="swiper-button-prev text-white hover:text-[var(--clr-accent)] transition-colors duration-300"></div>
        </div>
    </section>

    @pushOnce('styles')
        <link rel="stylesheet" href="https://unpkg.com/swiper/swiper-bundle.min.css" />
    @endPushOnce

    @pushOnce('scripts')
        <script src="https://unpkg.com/swiper/swiper-bundle.min.js"></script>
        <script>
            document.addEventListener('DOMContentLoaded', function () {
                const heroSwiper = new Swiper('.hero-swiper', {
                    loop: true,
                    autoplay: {
                        delay: 5000,
                        disableOnInteraction: false,
                    },
                    pagination: {
                        el: '.swiper-pagination',
                        clickable: true,
                    },
                    navigation: {
                        nextEl: '.swiper-button-next',
                        prevEl: '.swiper-button-prev',
                    },
                });
            });
        </script>
    @endPushOnce
@else
    {{-- Fallback if no slides are configured for the hero section --}}
    <section class="min-h-[50vh] flex items-center justify-center bg-gradient-to-br from-purple-600 via-indigo-700 to-pink-600 dark:from-purple-700 dark:via-indigo-800 dark:to-pink-700 text-white">
        <div class="container mx-auto px-4 text-center">
            <h2 class="text-3xl font-semibold mb-4">Hero Section Awaits Content</h2>
            <p class="text-lg text-purple-200">Please add slides in the page editor to activate this hero section.</p>
        </div>
    </section>
@endif