{{--
    AI Website Maker "Features Showcase" Section
    Expects $content to contain:
    - section_title: string (Optional, defaults to "Powerful Features")
    - section_subtitle: string (Optional)
    - features: array of objects, each with:
        - icon: string (SVG code or icon class)
        - title: string
        - description: string
        - link: string (Optional URL for a "learn more" link)
--}}
@php
    $sectionTitle = $content['section_title'] ?? 'Powerful Features, Effortless Creation';
    $sectionSubtitle = $content['section_subtitle'] ?? 'Discover what makes our AI Website Maker the perfect tool for your online presence.';
    $defaultFeatures = [
        [
            'icon' => '<svg aria-hidden="true" xmlns="http://www.w3.org/2000/svg" fill="none" viewBox="0 0 24 24" stroke-width="1.5" stroke="currentColor" class="w-10 h-10 text-primary-500 dark:text-primary-400"><path stroke-linecap="round" stroke-linejoin="round" d="M9.813 15.904L9 18.75l-.813-2.846a4.5 4.5 0 00-3.09-3.09L2.25 12l2.846-.813a4.5 4.5 0 003.09-3.09L9 5.25l.813 2.846a4.5 4.5 0 003.09 3.09L15.75 12l-2.846.813a4.5 4.5 0 00-3.09 3.09zM18.259 8.715L18 9.75l-.259-1.035a3.375 3.375 0 00-2.455-2.456L14.25 6l1.036-.259a3.375 3.375 0 002.455-2.456L18 2.25l.259 1.035a3.375 3.375 0 002.456 2.456L21.75 6l-1.035.259a3.375 3.375 0 00-2.456 2.456zM16.894 20.567L16.5 21.75l-.394-1.183a2.25 2.25 0 00-1.423-1.423L13.5 18.75l1.183-.394a2.25 2.25 0 001.423-1.423l.394-1.183.394 1.183a2.25 2.25 0 001.423 1.423l1.183.394-1.183.394a2.25 2.25 0 00-1.423 1.423z" /></svg>',
            'title' => 'AI-Powered Design',
            'description' => 'Intelligent algorithms create stunning, unique designs tailored to your industry and preferences.',
            'link' => '#'
        ],
        [
            'icon' => '<svg aria-hidden="true" xmlns="http://www.w3.org/2000/svg" fill="none" viewBox="0 0 24 24" stroke-width="1.5" stroke="currentColor" class="w-10 h-10 text-primary-500 dark:text-primary-400"><path stroke-linecap="round" stroke-linejoin="round" d="M16.023 9.348h4.992v-.001M2.985 19.644v-4.992m0 0h4.992m-4.993 0l3.181 3.183a8.25 8.25 0 0013.803-3.7M4.031 9.865a8.25 8.25 0 0113.803-3.7l3.181 3.182m0-4.991v4.99" /></svg>',
            'title' => 'Instant Content Generation',
            'description' => 'Need copy? Our AI can write engaging text for your pages, saving you time and effort.',
            'link' => '#'
        ],
        [
            'icon' => '<svg aria-hidden="true" xmlns="http://www.w3.org/2000/svg" fill="none" viewBox="0 0 24 24" stroke-width="1.5" stroke="currentColor" class="w-10 h-10 text-primary-500 dark:text-primary-400"><path stroke-linecap="round" stroke-linejoin="round" d="M10.5 1.5H8.25A2.25 2.25 0 006 3.75v16.5a2.25 2.25 0 002.25 2.25h7.5A2.25 2.25 0 0018 20.25V3.75a2.25 2.25 0 00-2.25-2.25H13.5m-3 0V3h3V1.5m-3 0h3m-3 18.75h3" /></svg>',
            'title' => 'Fully Responsive',
            'description' => 'Websites look perfect on any device – desktop, tablet, or mobile – automatically.',
            'link' => '#'
        ],
    ];
    $features = $content['features'] ?? $defaultFeatures;
@endphp

<section class="py-16 md:py-24 bg-white dark:bg-slate-900">
    <div class="container mx-auto px-4 sm:px-6 lg:px-8">
        <div class="text-center mb-12 md:mb-16">
            <h2 class="font-lexend text-3xl sm:text-4xl font-bold text-slate-800 dark:text-white mb-3">
                {{ $sectionTitle }}
            </h2>
            @if(!empty($sectionSubtitle))
            <p class="text-lg text-slate-600 dark:text-slate-300 max-w-3xl mx-auto">
                {{ $sectionSubtitle }}
            </p>
            @endif
        </div>

        <div class="grid sm:grid-cols-2 lg:grid-cols-3 gap-8">
            @if(is_array($features) && count($features) > 0)
                @foreach($features as $feature)
                    <div class="group p-6 bg-slate-50 dark:bg-slate-800/60 rounded-xl shadow-lg hover:shadow-primary-500/10 dark:hover:shadow-primary-400/10 transition-all duration-300 ease-in-out transform hover:-translate-y-1">
                        <div class="flex justify-center items-center mb-5 w-16 h-16 bg-primary-100 dark:bg-primary-500/20 rounded-lg mx-auto group-hover:scale-110 transition-transform duration-300">
                            {!! $feature['icon'] ?? '<svg aria-hidden="true" xmlns="http://www.w3.org/2000/svg" fill="none" viewBox="0 0 24 24" stroke-width="1.5" stroke="currentColor" class="w-8 h-8 text-primary-600 dark:text-primary-400"><path stroke-linecap="round" stroke-linejoin="round" d="M12 6.042A8.967 8.967 0 006 3.75c-1.052 0-2.062.18-3 .512v14.25A8.987 8.987 0 016 18c2.305 0 4.408.867 6 2.292m0-14.25a8.966 8.966 0 016-2.292c1.052 0 2.062.18 3 .512v14.25A8.987 8.987 0 0018 18a8.967 8.967 0 00-6 2.292m0-14.25v14.25" /></svg>' !!}
                        </div>
                        <h3 class="font-lexend text-xl font-semibold text-slate-700 dark:text-white mb-2 text-center">
                            {{ $feature['title'] ?? 'Feature Title' }}
                        </h3>
                        <p class="text-slate-500 dark:text-slate-400 text-sm leading-relaxed text-center">
                            {{ $feature['description'] ?? 'Feature description goes here.' }}
                        </p>
                        @if(!empty($feature['link']) && $feature['link'] !== '#')
                            <div class="mt-4 text-center">
                                <a href="{{ $feature['link'] }}" class="text-sm font-medium text-primary-600 dark:text-primary-400 hover:text-primary-500 dark:hover:text-primary-300 group-hover:underline">
                                    Learn More &rarr;
                                </a>
                            </div>
                        @endif
                    </div>
                @endforeach
            @else
                <p class="sm:col-span-2 lg:col-span-3 text-center text-slate-500 dark:text-slate-400">Features will be displayed here once configured.</p>
            @endif
        </div>
    </div>
</section>