{{--
    AI Website Maker "FAQ" Section
    Expects $content to contain:
    - section_title: string (Optional, defaults to "Frequently Asked Questions")
    - section_subtitle: string (Optional)
    - faqs: array of objects, each with:
        - question: string
        - answer: string
--}}
@php
    $sectionTitle = $content['section_title'] ?? 'Frequently Asked Questions';
    $sectionSubtitle = $content['section_subtitle'] ?? 'Find answers to common questions about our AI Website Maker.';
    $faqs = $content['faqs'] ?? [
        // Default placeholder FAQs if none are configured
        [
            'question' => 'How does the AI website creation process work?',
            'answer' => 'Our AI analyzes your industry, preferences, and content goals to generate a unique website design and initial content. You can then customize it further using our intuitive editor.',
        ],
        [
            'question' => 'Can I use my own domain name?',
            'answer' => 'Yes, with our Pro and Business plans, you can easily connect your custom domain name to your AI-generated website.',
        ],
        [
            'question' => 'Is hosting included?',
            'answer' => 'Yes, all our plans include reliable and fast hosting, so you don\'t have to worry about separate hosting arrangements.',
        ],
        [
            'question' => 'What kind of support do you offer?',
            'answer' => 'We offer community support for our Starter plan, and priority email/chat support for Pro and Business plan subscribers. We also have an extensive knowledge base.',
        ],
    ];
@endphp

<section class="py-16 md:py-24 bg-white dark:bg-slate-900">
    <div class="container mx-auto px-4 sm:px-6 lg:px-8">
        <div class="text-center mb-12 md:mb-16">
            <h2 class="font-lexend text-3xl sm:text-4xl font-bold text-slate-800 dark:text-white mb-3">
                {{ $sectionTitle }}
            </h2>
            @if(!empty($sectionSubtitle))
            <p class="text-lg text-slate-600 dark:text-slate-300 max-w-3xl mx-auto">
                {{ $sectionSubtitle }}
            </p>
            @endif
        </div>

        @if(is_array($faqs) && count($faqs) > 0)
            <div class="max-w-3xl mx-auto space-y-4">
                @foreach($faqs as $index => $faq)
                    <div x-data="{ open: {{ $index === 0 ? 'true' : 'false' }} }" class="bg-slate-50 dark:bg-slate-800/60 rounded-xl shadow-md overflow-hidden">
                        <button @click="open = !open" class="w-full flex justify-between items-center text-left px-6 py-4 focus:outline-none">
                            <h3 class="font-lexend text-lg font-semibold text-slate-700 dark:text-white">{{ $faq['question'] ?? 'Question?' }}</h3>
                            <svg class="w-6 h-6 text-primary-500 dark:text-primary-400 transform transition-transform duration-200" :class="{ 'rotate-180': open }" fill="none" stroke="currentColor" viewBox="0 0 24 24" xmlns="http://www.w3.org/2000/svg"><path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M19 9l-7 7-7-7"></path></svg>
                        </button>
                        <div x-show="open" x-collapse class="px-6 pb-4 pt-0">
                            <p class="text-slate-600 dark:text-slate-300 text-sm leading-relaxed">{{ $faq['answer'] ?? 'Answer goes here.' }}</p>
                        </div>
                    </div>
                @endforeach
            </div>
        @else
            <p class="text-center text-slate-500 dark:text-slate-400">FAQ items will be displayed here once configured.</p>
        @endif
    </div>
</section>
