@php
    $topBarTagline = setting('top_bar_tagline', 'Your Expert Digital Partner');
    $whatsappNumber = setting('whatsapp_number');
    $whatsappDefaultMessage = setting('whatsapp_default_message', 'Hello! I have a question.');
    $contactEmail = setting('contact_email');
    $socialFacebookUrl = setting('social_facebook_url');
    $socialTwitterUrl = setting('social_twitter_url');
    $socialLinkedinUrl = setting('social_linkedin_url');
    // Add other social links as needed for the top bar
@endphp

@if($topBarTagline || $whatsappNumber || $contactEmail || $socialFacebookUrl || $socialTwitterUrl || $socialLinkedinUrl)
<div class="bg-[var(--clr-top-bar-bg)] text-[var(--clr-top-bar-text)] text-xs sm:text-sm py-2 px-4 sm:px-6 lg:px-8 shadow-sm print:hidden">
    <div class="container mx-auto flex justify-between items-center">
        {{-- Start Side: Tagline --}}
        <div class="flex-grow text-center sm:text-start">
            @if($topBarTagline)
            <span>{{ $topBarTagline }}</span>
            @endif
        </div>

        {{-- End Side: Social Links / WhatsApp --}}
        <div class="flex items-center space-x-3 sm:space-x-4 flex-shrink-0">

            @if($contactEmail)
            <a href="mailto:{{ $contactEmail }}" class="hover:text-blue-500 dark:hover:text-blue-400 transition-colors duration-300 flex items-center" title="Send us an email">
                <i class="fas fa-envelope fa-fw sm:fa-lg me-1"></i>
                <span class="hidden md:inline">{{ $contactEmail }}</span> {{-- Show email text on medium screens and up --}}
            </a>
            @endif

            @if($whatsappNumber)
            <a href="https://wa.me/{{ preg_replace('/[^0-9]/', '', $whatsappNumber) }}?text={{ urlencode($whatsappDefaultMessage) }}" target="_blank" rel="noopener noreferrer" class="hover:text-green-500 dark:hover:text-green-400 transition-colors duration-300 flex items-center" title="Chat on WhatsApp">
                <i class="fab fa-whatsapp fa-fw sm:fa-lg me-1"></i>
                <span class="hidden md:inline">WhatsApp</span> {{-- Show 'WhatsApp' text on medium screens and up --}}
            </a>
            @endif

            @if($socialFacebookUrl)
            <a href="{{ $socialFacebookUrl }}" target="_blank" rel="noopener noreferrer" class="hover:text-blue-600 dark:hover:text-blue-500 transition-colors duration-300" title="Facebook">
                <i class="fab fa-facebook-f fa-fw sm:fa-lg"></i>
            </a>
            @endif
            @if($socialTwitterUrl)
            <a href="{{ $socialTwitterUrl }}" target="_blank" rel="noopener noreferrer" class="hover:text-sky-500 dark:hover:text-sky-400 transition-colors duration-300" title="Twitter / X">
                <i class="fab fa-twitter fa-fw sm:fa-lg"></i> {{-- or fa-brands fa-x-twitter for the new X logo --}}
            </a>
            @endif
            @if($socialLinkedinUrl)
            <a href="{{ $socialLinkedinUrl }}" target="_blank" rel="noopener noreferrer" class="hover:text-blue-700 dark:hover:text-blue-600 transition-colors duration-300" title="LinkedIn">
                <i class="fab fa-linkedin-in fa-fw sm:fa-lg"></i>
            </a>
            @endif
            {{-- Add other social icons (YouTube, TikTok, Instagram) here if desired for the top bar --}}
        </div>
    </div>
</div>
@endif