{{--
    Frontend Menu Item Partial
    Expects:
    - $item: A Modules\LandingPage\Entities\MenuItem instance
    - $page: The current LpPage instance (optional)
    - $isMobile: Boolean, true if rendering for mobile menu (optional)
--}}
@props(['item', 'page' => null, 'isMobile' => false])

@php
    $hasChildren = $item->childrenRecursive && $item->childrenRecursive->isNotEmpty();
    $link = $item->link; // Uses the getLinkAttribute() accessor from MenuItem model

    // Base classes
    $linkBaseClasses = 'flex items-center px-3 py-2 rounded-md transition-colors duration-150 ease-in-out';
    $linkDesktopClasses = 'text-sm font-medium';
    $linkMobileClasses = 'text-base font-medium w-full'; // Mobile links might be wider

    $activeClasses = 'bg-sky-100 text-sky-700 dark:bg-sky-700 dark:text-sky-100 font-semibold';
    $inactiveClasses = 'text-slate-700 hover:bg-slate-100 hover:text-slate-900 dark:text-slate-300 dark:hover:bg-slate-700 dark:hover:text-slate-100';

    // Determine if the current item is active
    // Check against current page slug if item type is 'page'
    $isCurrentItemActive = request()->fullUrlIs($link . '*');
    if (!$isCurrentItemActive && $item->type === 'page' && $item->page_id && $page && $item->page_id === $page->id) {
        $isCurrentItemActive = true;
    }
@endphp

<li class="{{ $item->css_class ?? '' }} {{ $hasChildren ? ($isMobile ? 'mobile-has-children' : 'has-children relative group') : '' }} {{ $isCurrentItemActive ? ($isMobile ? 'mobile-active' : 'active') : '' }}">
    <a href="{{ $link }}"
       target="{{ $item->target ?? '_self' }}"
       class="{{ $linkBaseClasses }} {{ $isMobile ? $linkMobileClasses : $linkDesktopClasses }} {{ $isCurrentItemActive ? $activeClasses : $inactiveClasses }}"
       aria-haspopup="{{ $hasChildren ? 'true' : 'false' }}"
       @if($hasChildren && $isMobile) x-data="{ open: false }" @click.prevent="open = !open" :aria-expanded="open.toString()" @else aria-expanded="false" @endif>
        @if($item->icon_class)
            <i class="{{ $item->icon_class }} mr-2"></i>
        @endif
        <span>{{ $item->title }}</span>
        @if($hasChildren)
            {{-- Chevron for Desktop Dropdown --}}
            <svg class="ml-auto h-4 w-4 {{ $isMobile ? 'hidden' : 'text-slate-400 group-hover:text-slate-500 dark:group-hover:text-slate-300' }} transition-transform duration-200 transform"
                 xmlns="http://www.w3.org/2000/svg" viewBox="0 0 20 20" fill="currentColor" aria-hidden="true">
                <path fill-rule="evenodd" d="M5.293 7.293a1 1 0 011.414 0L10 10.586l3.293-3.293a1 1 0 111.414 1.414l-4 4a1 1 0 01-1.414 0l-4-4a1 1 0 010-1.414z" clip-rule="evenodd" />
            </svg>
            {{-- Chevron for Mobile Accordion --}}
            <svg class="ml-auto h-5 w-5 {{ $isMobile ? 'block' : 'hidden' }} transform transition-transform duration-200"
                 :class="{ 'rotate-180': open }"
                 xmlns="http://www.w3.org/2000/svg" viewBox="0 0 20 20" fill="currentColor" aria-hidden="true">
                <path fill-rule="evenodd" d="M5.293 7.293a1 1 0 011.414 0L10 10.586l3.293-3.293a1 1 0 111.414 1.414l-4 4a1 1 0 01-1.414 0l-4-4a1 1 0 010-1.414z" clip-rule="evenodd" />
            </svg>
        @endif
    </a>

    @if($hasChildren)
        <ul class="{{ $isMobile ? 'submenu-mobile mt-1 space-y-1 pl-7' : 'submenu absolute left-0 mt-1 w-56 origin-top-left bg-white dark:bg-slate-800 border border-slate-200 dark:border-slate-700 rounded-md shadow-lg ring-1 ring-black ring-opacity-5 focus:outline-none opacity-0 invisible group-hover:opacity-100 group-hover:visible transition-all duration-200 ease-in-out z-50' }}"
            @if($isMobile) x-show="open" x-collapse @endif
            role="menu" aria-orientation="vertical" aria-labelledby="menu-button-{{ $item->id }}">
            @foreach($item->childrenRecursive as $childItem)
                <x-LandingPage::themes.ai_website_maker.partials.menu-item-frontend :item="$childItem" :page="$page" :isMobile="$isMobile" />
            @endforeach
        </ul>
    @endif
</li>
