{{--
    AI Website Maker "Pricing Plans" Section
    Expects $content to contain:
    - section_title: string (Optional, defaults to "Flexible Pricing for Every Need")
    - section_subtitle: string (Optional)
    - plans: array of objects, each with:
        - name: string
        - price: string (e.g., "$29", "Free")
        - frequency: string (e.g., "/month", "/year", "one-time")
        - features: array of strings
        - cta_text: string (e.g., "Get Started", "Choose Plan")
        - cta_link: string (URL)
        - highlighted: boolean (Optional, to make a plan stand out)
        - highlight_text: string (Optional, e.g., "Most Popular", defaults to "Popular")
--}}
@php
    $sectionTitle = $content['section_title'] ?? 'Flexible Pricing for Every Need';
    $sectionSubtitle = $content['section_subtitle'] ?? 'Choose the perfect plan to launch and grow your online presence with AI.';
    $plans = $content['plans'] ?? [
        // Default placeholder plans if none are configured
        [
            'name' => 'Starter',
            'price' => '$19',
            'frequency' => '/month',
            'features' => ['1 AI Website', 'Basic AI Features', 'Community Support', '10GB Storage'],
            'cta_text' => 'Choose Starter',
            'cta_link' => '#',
            'highlighted' => false,
        ],
        [
            'name' => 'Pro',
            'price' => '$49',
            'frequency' => '/month',
            'features' => ['5 AI Websites', 'Advanced AI Features', 'Priority Support', '50GB Storage', 'Custom Domain'],
            'cta_text' => 'Choose Pro',
            'cta_link' => '#',
            'highlighted' => true,
            'highlight_text' => 'Most Popular'
        ],
        [
            'name' => 'Business',
            'price' => '$99',
            'frequency' => '/month',
            'features' => ['Unlimited AI Websites', 'All AI Features', 'Dedicated Support', '200GB Storage', 'E-commerce Ready'],
            'cta_text' => 'Choose Business',
            'cta_link' => '#',
            'highlighted' => false,
        ],
    ];
@endphp

<section class="py-16 md:py-24 bg-slate-50 dark:bg-slate-800/50">
    <div class="container mx-auto px-4 sm:px-6 lg:px-8">
        <div class="text-center mb-12 md:mb-16">
            <h2 class="font-lexend text-3xl sm:text-4xl font-bold text-slate-800 dark:text-white mb-3">
                {{ $sectionTitle }}
            </h2>
            @if(!empty($sectionSubtitle))
            <p class="text-lg text-slate-600 dark:text-slate-300 max-w-3xl mx-auto">
                {{ $sectionSubtitle }}
            </p>
            @endif
        </div>

        <div class="grid grid-cols-1 md:grid-cols-2 lg:grid-cols-3 gap-8 items-stretch">
            @if(is_array($plans) && count($plans) > 0)
                @foreach($plans as $plan)
                    <div class="relative flex flex-col p-6 md:p-8 rounded-xl shadow-lg transition-all duration-300 ease-in-out
                                {{ ($plan['highlighted'] ?? false) ? 'bg-primary-500 dark:bg-primary-600 text-white transform scale-105 ring-4 ring-primary-300 dark:ring-primary-500' : 'bg-white dark:bg-slate-800 hover:shadow-primary-500/10 dark:hover:shadow-primary-400/10' }}">
                        @if($plan['highlighted'] ?? false)
                            <div class="absolute top-0 -translate-y-1/2 left-1/2 -translate-x-1/2">
                                <span class="px-3 py-1 text-xs font-semibold tracking-wide uppercase bg-yellow-400 text-yellow-900 rounded-full">{{ $plan['highlight_text'] ?? 'Popular' }}</span>
                            </div>
                        @endif
                        <h3 class="font-lexend text-2xl font-semibold mb-2 {{ ($plan['highlighted'] ?? false) ? 'text-white' : 'text-slate-700 dark:text-white' }}">{{ $plan['name'] ?? 'Plan Name' }}</h3>
                        <div class="mb-5">
                            <span class="text-4xl font-bold {{ ($plan['highlighted'] ?? false) ? 'text-white' : 'text-slate-800 dark:text-white' }}">{{ $plan['price'] ?? '$0' }}</span>
                            <span class="text-sm {{ ($plan['highlighted'] ?? false) ? 'text-primary-100' : 'text-slate-500 dark:text-slate-400' }}">{{ $plan['frequency'] ?? '/month' }}</span>
                        </div>
                        <ul class="space-y-3 mb-8 flex-grow {{ ($plan['highlighted'] ?? false) ? 'text-primary-50' : 'text-slate-600 dark:text-slate-300' }}">
                            @foreach($plan['features'] ?? [] as $featureText)
                                <li class="flex items-center"><svg class="w-5 h-5 mr-2 {{ ($plan['highlighted'] ?? false) ? 'text-yellow-400' : 'text-primary-500 dark:text-primary-400' }}" fill="currentColor" viewBox="0 0 20 20" xmlns="http://www.w3.org/2000/svg"><path fill-rule="evenodd" d="M16.707 5.293a1 1 0 010 1.414l-8 8a1 1 0 01-1.414 0l-4-4a1 1 0 011.414-1.414L8 12.586l7.293-7.293a1 1 0 011.414 0z" clip-rule="evenodd"></path></svg> {{ $featureText }}</li>
                            @endforeach
                        </ul>
                        <a href="{{ $plan['cta_link'] ?? '#' }}" class="block w-full text-center px-6 py-3 rounded-lg font-semibold transition-colors duration-200
                                   {{ ($plan['highlighted'] ?? false) ? 'bg-white text-primary-600 hover:bg-primary-50 dark:bg-slate-100 dark:text-primary-700 dark:hover:bg-slate-200' : 'bg-primary-500 text-white hover:bg-primary-600 dark:bg-primary-600 dark:hover:bg-primary-700' }}">
                            {{ $plan['cta_text'] ?? 'Choose Plan' }}
                        </a>
                    </div>
                @endforeach
            @else
                <p class="md:col-span-2 lg:col-span-3 text-center text-slate-500 dark:text-slate-400">Pricing plans will be displayed here once configured.</p>
            @endif
        </div>
    </div>
</section>