@php
    $title = $section->content['title'] ?? 'Need Assistance?';
    $description = $section->content['description'] ?? 'Our dedicated support team is ready to help. Reach out for any queries or issues.';
    $primaryButtonText = $section->content['primary_button_text'] ?? 'Contact Support';
    $primaryButtonLink = $section->content['primary_button_link'] ?? '#contact'; // Link to your support/contact page
    $secondaryButtonText = $section->content['secondary_button_text'] ?? null;
    $secondaryButtonLink = $section->content['secondary_button_link'] ?? null;
@endphp

<section class="py-16 md:py-24 bg-slate-100 dark:bg-slate-800">
    <div class="container mx-auto px-6 lg:px-8 text-center">
        <h2 class="text-3xl md:text-4xl font-bold text-slate-800 dark:text-white mb-6">
            {{ $title }}
        </h2>
        <p class="text-lg text-slate-600 dark:text-slate-300 mb-10 max-w-2xl mx-auto">
            {{ $description }}
        </p>
        <div class="flex flex-col sm:flex-row justify-center items-center gap-4">
            @if($primaryButtonText && $primaryButtonLink)
                <a href="{{ url($primaryButtonLink) }}"
                   class="inline-block bg-purple-600 hover:bg-purple-700 text-white font-semibold py-3 px-8 rounded-lg text-lg shadow-md transition duration-300 ease-in-out transform hover:scale-105">
                    {{ $primaryButtonText }}
                </a>
            @endif
            @if($secondaryButtonText && $secondaryButtonLink)
                <a href="{{ url($secondaryButtonLink) }}"
                   class="inline-block bg-transparent hover:bg-slate-200 dark:hover:bg-slate-700 text-purple-600 dark:text-purple-400 font-semibold py-3 px-8 rounded-lg text-lg border-2 border-purple-600 dark:border-purple-400 transition duration-300 ease-in-out">
                    {{ $secondaryButtonText }}
                </a>
            @endif
        </div>
    </div>
</section>