<!DOCTYPE html>
<html lang="{{ str_replace('_', '-', app()->getLocale()) }}" x-data="{ darkMode: localStorage.getItem('darkMode') === 'true' }" x-init="$watch('darkMode', val => localStorage.setItem('darkMode', val))" :class="{ 'dark': darkMode }">
<head>
    <meta charset="utf-8">
    <meta name="viewport" content="width=device-width, initial-scale=1">
    <meta name="csrf-token" content="{{ csrf_token() }}">

    <title>@yield('title', config('app.name', 'Laravel')) - {{ config('app.admin_panel_name', 'Admin Panel') }}</title>

    <!-- Fonts -->
    <link rel="preconnect" href="https://fonts.bunny.net">
    <link href="https://fonts.bunny.net/css?family=figtree:400,500,600&display=swap" rel="stylesheet" />

    <!-- Scripts -->
    @vite(['resources/css/app.css', 'resources/js/app.js']) {{-- Main app assets (Tailwind, Alpine, etc.) --}}

    {{-- Add FontAwesome or other icon libraries if your views use them --}}
    {{-- Consider managing FontAwesome via npm and importing it in your app.js/app.scss for better control --}}
    <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.4.0/css/all.min.css">

    @stack('styles') {{-- For page-specific styles --}}
    @livewireStyles {{-- If using Livewire --}}
</head>
<body class="font-sans antialiased bg-slate-100 dark:bg-slate-900 text-slate-600 dark:text-slate-400">
    <div class="flex h-screen overflow-hidden">

        <!-- Sidebar -->
        <aside x-data="{ sidebarOpen: false }" @keydown.escape.window="sidebarOpen = false"
            class="fixed inset-y-0 left-0 z-50 flex flex-col w-64 px-4 py-8 overflow-y-auto bg-white border-r rtl:border-r-0 rtl:border-l dark:bg-slate-800 dark:border-slate-700 transform md:translate-x-0 transition-transform duration-200 ease-in-out"
            :class="{'translate-x-0': sidebarOpen, '-translate-x-full': !sidebarOpen}">

            <a href="{{ route('admin.dashboard') }}" class="flex items-center px-2 mb-5">
                {{-- <img class="w-auto h-8" src="/path/to/your/logo.svg" alt="Logo"> --}}
                {{-- Consider using a setting for the admin logo as well, similar to site_logo --}}
                {{-- <img class="w-auto h-8" src="{{ setting('admin_panel_logo') ? asset('storage/' . setting('admin_panel_logo')) : '/default-admin-logo.svg' }}" alt="Admin Logo"> --}}
                <span class="ml-2 text-xl font-semibold text-slate-800 dark:text-white">{{ config('app.name', 'Laravel') }}</span>
            </a>

            <div class="flex flex-col justify-between flex-1 mt-6">
                <nav class="-mx-3 space-y-3 ">
                    {{-- Example Sidebar Link --}}
                    <a class="flex items-center px-3 py-2 text-slate-600 transition-colors duration-300 transform rounded-lg dark:text-slate-200 hover:bg-slate-100 dark:hover:bg-slate-700 dark:hover:text-slate-200 hover:text-slate-700 {{ request()->routeIs('admin.dashboard') ? 'bg-slate-100 dark:bg-slate-700' : '' }}"
                       href="{{ route('admin.dashboard') }}">
                        <i class="fas fa-tachometer-alt w-5 h-5"></i>
                        <span class="mx-2 text-sm font-medium">Dashboard</span>
                    </a>

                    {{-- Landing Page Module Links (Example) --}}
                     <a class="flex items-center px-3 py-2 text-slate-600 transition-colors duration-300 transform rounded-lg dark:text-slate-200 hover:bg-slate-100 dark:hover:bg-slate-700 dark:hover:text-slate-200 hover:text-slate-700 {{ request()->routeIs('admin.landingpage.*') ? 'bg-slate-100 dark:bg-slate-700' : '' }}"
                       href="{{ route('admin.landingpage.pages.index') }}"> {{-- Assuming this is the main entry for landing pages --}}
                        <i class="fas fa-file-alt w-5 h-5"></i>
                        <span class="mx-2 text-sm font-medium">Landing Pages</span>
                    </a>

                    {{-- Menu Management Link --}}
                    <a class="flex items-center px-3 py-2 text-slate-600 transition-colors duration-300 transform rounded-lg dark:text-slate-200 hover:bg-slate-100 dark:hover:bg-slate-700 dark:hover:text-slate-200 hover:text-slate-700 {{ request()->routeIs('admin.landingpage.menus.*') || request()->routeIs('admin.landingpage.menuitems.*') ? 'bg-slate-100 dark:bg-slate-700' : '' }}"
                       href="{{ route('admin.landingpage.menus.index') }}">
                        <i class="fas fa-list-alt w-5 h-5"></i>
                        <span class="mx-2 text-sm font-medium">Menus</span>
                    </a>
                    {{-- Theme Settings Link --}}
                    <a class="flex items-center px-3 py-2 text-slate-600 transition-colors duration-300 transform rounded-lg dark:text-slate-200 hover:bg-slate-100 dark:hover:bg-slate-700 dark:hover:text-slate-200 hover:text-slate-700 {{ request()->routeIs('admin.landingpage.theme.settings.*') ? 'bg-slate-100 dark:bg-slate-700' : '' }}"
                       href="{{ route('admin.landingpage.theme.settings.edit') }}"> {{-- Assuming 'edit' is the main route for theme settings --}}
                        <i class="fas fa-palette w-5 h-5"></i>
                        <span class="mx-2 text-sm font-medium">Theme Settings</span>
                    </a>
                    {{-- Add more navigation items here --}}
                </nav>

                {{-- Dark Mode Toggle Example --}}
                <div class="mt-auto pt-6">
                     <button @click="darkMode = !darkMode" class="flex items-center justify-center w-full px-3 py-2 text-sm font-medium text-slate-600 transition-colors duration-300 transform rounded-lg dark:text-slate-200 hover:bg-slate-100 dark:hover:bg-slate-700">
                        <span x-show="!darkMode"><i class="fas fa-moon w-5 h-5 mr-2"></i> Dark Mode</span>
                        <span x-show="darkMode"><i class="fas fa-sun w-5 h-5 mr-2"></i> Light Mode</span>
                    </button>
                </div>
            </div>
        </aside>

        <!-- Content area -->
        <div class="relative flex flex-col flex-1 overflow-y-auto overflow-x-hidden md:ml-64">
            <!-- Header -->
            <header class="sticky top-0 bg-white dark:bg-slate-800 border-b border-slate-200 dark:border-slate-700 z-30">
                <div class="px-4 sm:px-6 lg:px-8">
                    <div class="flex items-center justify-between h-16 -mb-px">
                        <!-- Hamburger button for mobile -->
                        <div class="md:hidden">
                            <button @click.stop="sidebarOpen = !sidebarOpen" class="text-slate-500 hover:text-slate-600">
                                <span class="sr-only">Open sidebar</span>
                                <svg class="w-6 h-6 fill-current" viewBox="0 0 24 24" xmlns="http://www.w3.org/2000/svg">
                                    <rect x="4" y="5" width="16" height="2" />
                                    <rect x="4" y="11" width="16" height="2" />
                                    <rect x="4" y="17" width="16" height="2" />
                                </svg>
                            </button>
                        </div>

                        <!-- Header: Right side -->
                        <div class="flex items-center space-x-3 ml-auto">
                            {{-- User Menu (Example) --}}
                            <div x-data="{ open: false }" class="relative inline-flex">
                                <button @click="open = !open" class="inline-flex justify-center items-center group">
                                    {{-- Consider a default avatar or initials if profile_photo_url is not set --}}
                                    {{-- <img class="w-8 h-8 rounded-full" src="{{ Auth::user()->profile_photo_url ?? 'https://ui-avatars.com/api/?name='.urlencode(Auth::user()->name ?? 'A D').'&color=7F9CF5&background=EBF4FF' }}" width="32" height="32" alt="{{ Auth::user()->name ?? 'User' }}" /> --}}
                                    <div class="flex items-center truncate">
                                        <span class="truncate ml-2 text-sm font-medium dark:text-slate-300 group-hover:text-slate-800 dark:group-hover:text-slate-200">{{ Auth::user()->name ?? 'Admin User' }}</span>
                                        <svg class="w-3 h-3 shrink-0 ml-1 fill-current text-slate-400" viewBox="0 0 12 12">
                                            <path d="M5.9 11.4L.5 6l1.4-1.4 4 4 4-4L11.3 6z" />
                                        </svg>
                                    </div>
                                </button>
                                <div x-show="open" @click.outside="open = false" @keydown.escape.window="open = false" class="origin-top-right z-10 absolute top-full right-0 min-w-44 bg-white dark:bg-slate-800 border border-slate-200 dark:border-slate-700 py-1.5 rounded shadow-lg overflow-hidden mt-1" style="display: none;">
                                    <ul>
                                        <li>
                                            {{-- Link to user profile/settings page if you have one --}}
                                            <a class="font-medium text-sm text-indigo-500 hover:text-indigo-600 dark:hover:text-indigo-400 flex items-center py-1 px-3" href="{{-- route('admin.profile.edit') --}}#">Profile Settings</a>
                                        </li>
                                        <li>
                                            <form method="POST" action="{{ route('logout') }}"> {{-- Adjust if your logout route is different --}}
                                                @csrf
                                                <button type="submit" class="font-medium text-sm text-indigo-500 hover:text-indigo-600 dark:hover:text-indigo-400 flex items-center py-1 px-3 w-full text-left">
                                                    Sign Out
                                                </button>
                                            </form>
                                        </li>
                                    </ul>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            </header>

        <!-- Page Content -->
        <main class="flex-1">
            <div class="py-6">
                @hasSection('header_title')
                <div class="max-w-7xl mx-auto px-4 sm:px-6 md:px-8 mb-6"> {{-- Added mb-6 for spacing --}}
                    <h1 class="text-2xl font-semibold text-slate-900 dark:text-white">@yield('header_title')</h1>
                </div>
                @endif
                <div class="max-w-7xl mx-auto px-4 sm:px-6 md:px-8"> {{-- This is where page-specific content will go --}}
                    @yield('content') {{-- This is where module_content (via landingpage::layouts.admin) will be injected --}}
                </div>
            </div>
        </main>
        </div>
    </div>
    @stack('scripts') {{-- For page-specific scripts --}}
    @livewireScripts {{-- If using Livewire --}}
</body>
</html>