@props([
    'title' => 'Service Title',
    'description' => 'Brief description of the service offered.',
    'iconSvg' => null, // Pass full SVG string or path to an icon
])

<div {{ $attributes->merge(['class' => 'bg-gray-50 dark:bg-gray-800 p-8 rounded-xl shadow-lg hover:shadow-2xl transition-shadow duration-300 transform hover:-translate-y-1']) }}>
    @if($iconSvg)
    <div class="text-purple-500 dark:text-purple-400 mb-6 inline-flex items-center justify-center w-16 h-16 bg-purple-100 dark:bg-purple-900/50 rounded-full">
        {!! $iconSvg !!} {{-- Make sure $iconSvg is safe if it's dynamic --}}
    </div>
    @endif
    <h3 class="text-xl font-semibold mb-3 text-gray-800 dark:text-white">{{ $title }}</h3>
    <p class="text-gray-600 dark:text-gray-400 text-sm leading-relaxed">{{ $description }}</p>
    {{-- You could add a "Learn More" link here if services have detail pages --}}
</div>