@props(['section', 'activeTheme'])

@if($section && isset($section->type) && isset($section->content))
    @php
        $sectionLayout = $section->layout ?? 'default';
        // Path for layout specific to section type: themes.theme_name.sections.layouts.SECTION_TYPE.LAYOUT_NAME.blade.php
        $specificLayoutPath = "landingpage::themes.{$activeTheme}.sections.layouts.{$section->type}.{$sectionLayout}";
        // Path for generic layout: themes.theme_name.sections.layouts.LAYOUT_NAME.blade.php
        $genericLayoutPath = "landingpage::themes.{$activeTheme}.sections.layouts.{$sectionLayout}";
        // Path for a very basic default layout: themes.theme_name.sections.layouts.default.blade.php
        $defaultLayoutPath = "landingpage::themes.{$activeTheme}.sections.layouts.default";

        // Data to pass to the included view
        $viewData = [
            'section' => $section,
            'title' => $section->title, // Section's own title, if any (distinct from content.title)
            'content' => $section->content, // The JSON content array
            'activeTheme' => $activeTheme, // Pass active theme for any nested components/logic
        ];
    @endphp

    @if (view()->exists($specificLayoutPath))
        @include($specificLayoutPath, $viewData)
    @elseif (view()->exists($genericLayoutPath))
        @include($genericLayoutPath, $viewData)
    @elseif (view()->exists($defaultLayoutPath))
        @include($defaultLayoutPath, $viewData)
    @else
        <div class="container mx-auto px-4 sm:px-6 lg:px-8 py-12 text-center">
            <p class="text-red-600 dark:text-red-400 font-semibold">Section Layout Missing!</p>
            <p class="text-sm text-slate-600 dark:text-slate-400 mt-2">
                Layout partial for section type "<strong>{{ $section->type }}</strong>" with layout "<strong>{{ $sectionLayout }}</strong>" not found in theme "<strong>{{ $activeTheme }}</strong>".
            </p>
            <p class="text-xs text-slate-500 dark:text-slate-500 mt-1">Attempted paths (most specific first):</p>
            <ul class="text-xs text-slate-500 dark:text-slate-500 mt-1 list-none">
                <li><code>themes/{{$activeTheme}}/sections/layouts/{{$section->type}}/{{$sectionLayout}}.blade.php</code></li>
                <li><code>themes/{{$activeTheme}}/sections/layouts/{{$sectionLayout}}.blade.php</code></li>
                <li><code>themes/{{$activeTheme}}/sections/layouts/default.blade.php</code></li>
            </ul>
            @if(config('app.debug') && isset($section->content))
            <div class="mt-4 p-2 bg-red-50 dark:bg-red-900 border border-red-200 dark:border-red-700 rounded text-xs text-left">
                <strong>Content Data:</strong>
                <pre class="whitespace-pre-wrap"><code>{{ json_encode($section->content, JSON_PRETTY_PRINT) }}</code></pre>
            </div>
            @endif
        </div>
    @endif
@else
@endif