@extends('landingpage::layouts.admin') {{-- Assuming your module has its own admin layout --}}

@section('title', 'Theme Settings')
@section('module_header_title', 'Landing Page Theme Settings') {{-- Or your layout's equivalent section --}}

@section('module_content')
<div class="px-4 sm:px-6 lg:px-8 py-8 w-full max-w-9xl mx-auto">
    <div class="sm:flex sm:justify-between sm:items-center mb-8">
        <h1 class="text-2xl md:text-3xl text-slate-800 dark:text-slate-100 font-bold">Theme & Analytics Settings</h1>
    </div>

    <nav class="mb-6 text-sm" aria-label="Breadcrumb">
        <ol class="list-none p-0 inline-flex">
            <li class="flex items-center">
                <a href="{{ route('admin.dashboard') }}" class="text-blue-500 hover:text-blue-700 hover:underline dark:text-blue-400 dark:hover:text-blue-300">Dashboard</a>
                <svg class="fill-current w-3 h-3 mx-3 text-slate-400" xmlns="http://www.w3.org/2000/svg" viewBox="0 0 320 512"><path d="M285.476 272.971L91.132 467.314c-9.373 9.373-24.569 9.373-33.941 0l-22.667-22.667c-9.357-9.357-9.375-24.522-.04-33.901L188.505 256 34.484 101.255c-9.335-9.379-9.317-24.544.04-33.901l22.667-22.667c9.373-9.373 24.569 9.373 33.941 0L285.475 239.03c9.373 9.372 9.373 24.568.001 33.941z"/></svg>
            </li>
            <li class="flex items-center">
                <span class="text-slate-500 dark:text-slate-400">Theme Settings</span>
            </li>
        </ol>
    </nav>

    @if(session('success'))
        <div class="mb-6 p-4 bg-green-50 border-l-4 border-green-400 text-green-700 dark:bg-green-900 dark:text-green-300 dark:border-green-600 rounded-md relative" role="alert">
            <strong class="font-bold">Success!</strong> {{ session('success') }}
            <button type="button" class="absolute top-0 bottom-0 right-0 px-4 py-3 text-green-700 dark:text-green-300 hover:text-green-900 dark:hover:text-green-100" onclick="this.parentElement.style.display='none';"><span>&times;</span></button>
        </div>
    @endif

    <form action="{{ route('admin.landingpage.theme.settings.update') }}" method="POST">
        @csrf
        @method('PUT')

        {{-- Theme Selection --}}
        <div class="bg-white dark:bg-slate-800 shadow-lg rounded-lg mb-6">
            <div class="px-6 py-4 border-b border-slate-200 dark:border-slate-700">
                <h3 class="text-lg font-medium text-slate-800 dark:text-slate-100">Theme Selection</h3>
            </div>
            <div class="p-6">
                <div>
                    <label for="landingpage_active_theme" class="block text-sm font-medium text-slate-700 dark:text-slate-300 mb-1">Active Theme</label>
                    <select name="landingpage_active_theme" id="landingpage_active_theme" required
                            class="mt-1 block w-full rounded-md border-slate-300 dark:border-slate-600 shadow-sm focus:border-blue-500 focus:ring-blue-500 sm:text-sm dark:bg-slate-700 dark:text-slate-200">
                        @foreach($availableThemes as $themeKey => $themeName) {{-- $activeTheme is expected to be the theme key, e.g., 'general' --}}
                            <option value="{{ $themeKey }}" {{ $activeTheme == $themeKey ? 'selected' : '' }}>
                                {{ $themeName }}
                            </option>
                        @endforeach
                    </select>
                    @error('landingpage_active_theme') <p class="mt-1 text-sm text-red-600 dark:text-red-400">{{ $message }}</p> @enderror
                </div>
                <div class="mt-4">
                    <label for="top_bar_tagline" class="block text-sm font-medium text-slate-700 dark:text-slate-300 mb-1">Top Bar Tagline/Keywords</label>
                    <input type="text" id="top_bar_tagline" name="top_bar_tagline" 
                           value="{{ old('top_bar_tagline', setting('top_bar_tagline', 'Your Expert Digital Partner')) }}"
                           class="mt-1 block w-full rounded-md border-slate-300 dark:border-slate-600 shadow-sm focus:border-blue-500 focus:ring-blue-500 sm:text-sm dark:bg-slate-700 dark:text-slate-200 @error('top_bar_tagline') border-red-500 @enderror"
                           placeholder="e.g., Innovative Solutions | Expert Team">
                    <p class="mt-1 text-xs text-slate-500 dark:text-slate-400">This text will appear in the top bar.</p>
                    @error('top_bar_tagline') <p class="mt-2 text-sm text-red-600 dark:text-red-400">{{ $message }}</p> @enderror
                </div>
            </div>
        </div>

        {{-- Theme Color Settings --}}
        <div class="bg-white dark:bg-slate-800 shadow-lg rounded-lg mb-6">
            <div class="px-6 py-4 border-b border-slate-200 dark:border-slate-700">
                <h3 class="text-lg font-medium text-slate-800 dark:text-slate-100">Theme Colors</h3>
                <p class="mt-1 text-xs text-slate-500 dark:text-slate-400">Enter HEX (e.g., #FF0000) or RGBA (e.g., rgba(255,0,0,0.5)) values.</p>
            </div>
            <div class="p-6">
                @php
                    $colorFields = [
                        'Light Mode' => [
                            'top_bar_bg_light' => 'Top Bar Background',
                            'top_bar_text_light' => 'Top Bar Text',
                            'header_bg_light' => 'Header Background',
                            'header_text_light' => 'Header Text',
                            'accent_color_light' => 'Accent Color',
                        ],
                        'Dark Mode' => [
                            'top_bar_bg_dark' => 'Top Bar Background',
                            'top_bar_text_dark' => 'Top Bar Text',
                            'header_bg_dark' => 'Header Background',
                            'header_text_dark' => 'Header Text',
                            'accent_color_dark' => 'Accent Color',
                        ]
                    ];
                @endphp

                <div class="grid grid-cols-1 md:grid-cols-2 gap-x-6 gap-y-8">
                    @foreach($colorFields as $mode => $fields)
                        <div class="space-y-6">
                            <h4 class="text-md font-semibold text-slate-700 dark:text-slate-200 mb-1 border-b border-slate-200 dark:border-slate-700 pb-2">{{ $mode }}</h4>
                            @foreach($fields as $key => $label)
                                <div>
                                    <label for="{{ $key }}" class="block text-sm font-medium text-slate-700 dark:text-slate-300 mb-1">{{ $label }}</label>
                                    <div class="flex items-center space-x-2">
                                        <input type="color" id="{{ $key }}_picker" value="{{ old($key, $colorSettings[$key] ?? '#ffffff') }}"
                                               class="p-1 h-10 w-10 block bg-white dark:bg-slate-700 border border-slate-300 dark:border-slate-600 cursor-pointer rounded-lg disabled:opacity-50 disabled:pointer-events-none"
                                               oninput="document.getElementById('{{ $key }}').value = this.value;">
                                        <input type="text" id="{{ $key }}" name="{{ $key }}"
                                               value="{{ old($key, $colorSettings[$key] ?? '') }}"
                                               class="mt-1 block w-full rounded-md border-slate-300 dark:border-slate-600 shadow-sm focus:border-blue-500 focus:ring-blue-500 sm:text-sm dark:bg-slate-700 dark:text-slate-200 @error($key) border-red-500 @enderror"
                                               placeholder="e.g., #RRGGBB or rgba(...)"
                                               onchange="document.getElementById('{{ $key }}_picker').value = this.value;">
                                    </div>
                                    @error($key) <p class="mt-1 text-xs text-red-600 dark:text-red-400">{{ $message }}</p> @enderror
                                </div>
                            @endforeach
                        </div>
                    @endforeach
                </div>
                 <script>
                    // Sync text input with color picker and vice-versa
                    document.addEventListener('DOMContentLoaded', function() {
                        const colorInputs = document.querySelectorAll('input[type="text"][id$="_light"], input[type="text"][id$="_dark"]');
                        colorInputs.forEach(textInput => {
                            const pickerInput = document.getElementById(textInput.id + '_picker');
                            if (pickerInput) {
                                // Initial sync: If text input has a valid color, set picker
                                try { pickerInput.value = textInput.value; } catch (e) { /* ignore if invalid for picker */ }

                                textInput.addEventListener('input', function() {
                                     try { pickerInput.value = this.value; } catch (e) { /* ignore if invalid for picker */ }
                                });
                            }
                        });
                    });
                </script>
            </div>
        </div>

        <!-- Contact & Social Settings Card -->
        <div class="bg-white dark:bg-slate-800 shadow-lg rounded-lg mb-6">
            <div class="px-6 py-4 border-b border-slate-200 dark:border-slate-700">
                <h3 class="text-lg font-medium text-slate-800 dark:text-slate-100">Contact & Social Settings</h3>
            </div>
            <div class="p-6">
                <div class="mb-4">
                    <label for="contact_email" class="block text-sm font-medium text-slate-700 dark:text-slate-300 mb-1">Contact Email</label>
                    <input type="email" id="contact_email" name="contact_email" class="mt-1 block w-full rounded-md border-slate-300 dark:border-slate-600 shadow-sm focus:border-blue-500 focus:ring-blue-500 sm:text-sm dark:bg-slate-700 dark:text-slate-200" value="{{ old('contact_email', $colorSettings['contact_email'] ?? '') }}" placeholder="e.g., info@example.com">
                    @error('contact_email') <p class="mt-1 text-sm text-red-500">{{ $message }}</p> @enderror
                    <p class="mt-1 text-xs text-slate-500 dark:text-slate-400">This email will be displayed in the top bar and footer.</p>
                </div>
                <div class="mb-4">
                    <label for="whatsapp_number" class="block text-sm font-medium text-slate-700 dark:text-slate-300 mb-1">WhatsApp Number</label>
                    <input type="text" id="whatsapp_number" name="whatsapp_number" class="mt-1 block w-full rounded-md border-slate-300 dark:border-slate-600 shadow-sm focus:border-blue-500 focus:ring-blue-500 sm:text-sm dark:bg-slate-700 dark:text-slate-200" value="{{ old('whatsapp_number', $colorSettings['whatsapp_number'] ?? '') }}" placeholder="e.g., +12345678900">
                    @error('whatsapp_number') <p class="mt-1 text-sm text-red-500">{{ $message }}</p> @enderror
                    <p class="mt-1 text-xs text-slate-500 dark:text-slate-400">Enter the full WhatsApp number including country code (e.g., +12345678900). Leave blank to disable the WhatsApp widget.</p>
                </div>

                <div class="mb-4">
                    <label for="whatsapp_default_message" class="block text-sm font-medium text-slate-700 dark:text-slate-300 mb-1">WhatsApp Default Message</label>
                    <textarea id="whatsapp_default_message" name="whatsapp_default_message" rows="3" class="mt-1 block w-full rounded-md border-slate-300 dark:border-slate-600 shadow-sm focus:border-blue-500 focus:ring-blue-500 sm:text-sm dark:bg-slate-700 dark:text-slate-200" placeholder="Hello! I have a question about your services.">{{ old('whatsapp_default_message', $colorSettings['whatsapp_default_message'] ?? '') }}</textarea>
                    @error('whatsapp_default_message') <p class="mt-1 text-sm text-red-500">{{ $message }}</p> @enderror
                    <p class="mt-1 text-xs text-slate-500 dark:text-slate-400">This message will be pre-filled when a user clicks the WhatsApp button.</p>
                </div>

                <hr class="my-6 border-slate-200 dark:border-slate-700">

                <h4 class="text-md font-semibold text-slate-700 dark:text-slate-300 mb-3">Social Media Links</h4>
                @php
                    $socialFields = [
                        'social_facebook_url' => 'Facebook URL',
                        'social_linkedin_url' => 'LinkedIn URL',
                        'social_youtube_url' => 'YouTube URL',
                        'social_twitter_url' => 'Twitter (X) URL',
                        'social_tiktok_url' => 'TikTok URL',
                        'social_instagram_url' => 'Instagram URL',
                    ];
                @endphp

                <div class="grid grid-cols-1 md:grid-cols-2 gap-x-6 gap-y-4">
                    @foreach($socialFields as $key => $label)
                    <div>
                        <label for="{{ $key }}" class="block text-sm font-medium text-slate-700 dark:text-slate-300 mb-1">{{ $label }}</label>
                        <input type="url" id="{{ $key }}" name="{{ $key }}" class="mt-1 block w-full rounded-md border-slate-300 dark:border-slate-600 shadow-sm focus:border-blue-500 focus:ring-blue-500 sm:text-sm dark:bg-slate-700 dark:text-slate-200 @error($key) border-red-500 @enderror" value="{{ old($key, $colorSettings[$key] ?? '') }}" placeholder="https://...">
                        @error($key) <p class="mt-1 text-sm text-red-500">{{ $message }}</p> @enderror
                    </div>
                    @endforeach
                </div>
            </div>
        </div>
        <!-- End Contact & Social Settings Card -->

        {{-- Site Identity Card (New) --}}
        <div class="bg-white dark:bg-slate-800 shadow-lg rounded-lg mb-6">
            <div class="px-6 py-4 border-b border-slate-200 dark:border-slate-700">
                <h3 class="text-lg font-medium text-slate-800 dark:text-slate-100">Site Identity & SEO Defaults</h3>
            </div>
            <div class="p-6">
                {{-- Site Name, Description, Keywords, Logo, Favicon, OG Image --}}
                {{-- These fields are already present in your app.blade.php logic, so we'd add inputs for them here --}}
                {{-- Example for Site Name: --}}
                <div class="mb-4">
                    <label for="site_name" class="block text-sm font-medium text-slate-700 dark:text-slate-300 mb-1">Site Name</label>
                    <input type="text" id="site_name" name="site_name" class="mt-1 block w-full rounded-md border-slate-300 dark:border-slate-600 shadow-sm focus:border-blue-500 focus:ring-blue-500 sm:text-sm dark:bg-slate-700 dark:text-slate-200" value="{{ old('site_name', setting('site_name', config('app.name'))) }}" placeholder="Your Awesome Site">
                    @error('site_name') <p class="mt-1 text-sm text-red-500">{{ $message }}</p> @enderror
                </div>
                {{-- Add other fields like site_description, site_logo_upload, site_favicon_upload, site_og_image_upload etc. --}}
                 <p class="text-xs text-slate-500 dark:text-slate-400">Note: Logo, Favicon, and Default OG Image uploads would require file handling logic in the controller.</p>
            </div>
        </div>
        <!-- End Contact & Social Settings Card -->

        {{-- Google Analytics Settings --}}
        <div class="bg-white dark:bg-slate-800 shadow-lg rounded-lg mb-6">
            <div class="px-6 py-4 border-b border-slate-200 dark:border-slate-700">
                <h3 class="text-lg font-medium text-slate-800 dark:text-slate-100">Google Analytics Settings</h3>
            </div>
            <div class="p-6 space-y-4">
                <div>
                    <label for="ga_enable_tracking" class="flex items-center">
                        <input type="checkbox" id="ga_enable_tracking" name="google_analytics_enable_tracking" value="1"
                               class="form-checkbox h-5 w-5 text-blue-600 dark:bg-slate-700 dark:border-slate-600 rounded focus:ring-blue-500"
                               {{ old('google_analytics_enable_tracking', $gaEnableTracking ?? false) ? 'checked' : '' }}>
                        <span class="ml-2 text-sm text-slate-700 dark:text-slate-300">Enable Google Analytics Tracking</span>
                    </label>
                </div>

                <div>
                    <label for="ga_tracking_id" class="block text-sm font-medium text-slate-700 dark:text-slate-300 mb-1">Google Analytics Measurement ID</label>
                    <input type="text" id="ga_tracking_id" name="google_analytics_tracking_id" value="{{ old('google_analytics_tracking_id', $gaTrackingId ?? '') }}"
                           class="mt-1 block w-full rounded-md border-slate-300 dark:border-slate-600 shadow-sm focus:border-blue-500 focus:ring-blue-500 sm:text-sm dark:bg-slate-700 dark:text-slate-200"
                           placeholder="G-XXXXXXXXXX">
                    <p class="mt-1 text-xs text-slate-500 dark:text-slate-400">Enter your GA4 Measurement ID.</p>
                </div>

                <div>
                    <label for="ga_property_id" class="block text-sm font-medium text-slate-700 dark:text-slate-300 mb-1">Google Analytics Property ID</label>
                    <input type="text" id="ga_property_id" name="google_analytics_property_id" value="{{ old('google_analytics_property_id', $gaPropertyId ?? '') }}"
                           class="mt-1 block w-full rounded-md border-slate-300 dark:border-slate-600 shadow-sm focus:border-blue-500 focus:ring-blue-500 sm:text-sm dark:bg-slate-700 dark:text-slate-200"
                           placeholder="Your GA4 Property ID (numeric)">
                    <p class="mt-1 text-xs text-slate-500 dark:text-slate-400">Required for fetching statistics from GA4.</p>
                </div>

                <div>
                    <label for="ga_credentials_path" class="block text-sm font-medium text-slate-700 dark:text-slate-300 mb-1">Service Account Credentials JSON Path</label>
                    <input type="text" id="ga_credentials_path" name="google_analytics_credentials_path" value="{{ old('google_analytics_credentials_path', $gaCredentialsPath ?? '') }}"
                           class="mt-1 block w-full rounded-md border-slate-300 dark:border-slate-600 shadow-sm focus:border-blue-500 focus:ring-blue-500 sm:text-sm dark:bg-slate-700 dark:text-slate-200"
                           placeholder="/path/to/your/service-account-credentials.json">
                    <p class="mt-1 text-xs text-slate-500 dark:text-slate-400">Absolute path to your Google Service Account JSON key file. Store this file securely (e.g., in <code>storage/app/google-analytics/</code> and add to <code>.gitignore</code>).</p>
                </div>

                {{-- How-to Guide for Google Analytics Setup --}}
                <div class="mt-6 pt-6 border-t border-slate-200 dark:border-slate-700">
                    <h4 class="text-md font-semibold text-slate-700 dark:text-slate-200 mb-3">How to Set Up Google Analytics API Access:</h4>
                    <ol class="list-decimal list-inside space-y-2 text-sm text-slate-600 dark:text-slate-400">
                        <li>
                            <strong>Google Cloud Project:</strong>
                            Go to the <a href="https://console.cloud.google.com/" target="_blank" class="text-blue-500 hover:underline">Google Cloud Console</a>.
                            Create a new project or select an existing one.
                        </li>
                        <li>
                            <strong>Enable API:</strong>
                            In your Google Cloud Project, navigate to "APIs & Services" &rarr; "Library". Search for and enable the "<strong>Google Analytics Data API</strong>".
                        </li>
                        <li>
                            <strong>Create Service Account:</strong>
                            Go to "IAM & Admin" &rarr; "Service Accounts". Click "Create Service Account".
                            Give it a name (e.g., "Website Analytics Reader").
                            Grant it the "<strong>Analytics Reader</strong>" role (under "Analytics" roles). You can refine permissions later if needed.
                        </li>
                        <li>
                            <strong>Create JSON Key:</strong>
                            After creating the service account, click on its email address. Go to the "Keys" tab. Click "Add Key" &rarr; "Create new key". Choose "JSON" and click "Create". A JSON file will download.
                        </li>
                        <li>
                            <strong>Add Service Account to GA4:</strong>
                            In your <a href="https://analytics.google.com/" target="_blank" class="text-blue-500 hover:underline">Google Analytics 4 Property</a>, go to "Admin" (bottom left gear icon) &rarr; "Property Access Management" (under the Property column).
                            Click the "+" icon to add a new user. Enter the service account's email address (e.g., <code>your-service-account@your-project-id.iam.gserviceaccount.com</code>) and assign it "Viewer" permissions.
                        </li>
                        <li>
                            <strong>Store Credentials & Configure Path:</strong>
                            Place the downloaded JSON key file in a secure, non-public location on your server (e.g., <code>storage/app/google-analytics/service-account-credentials.json</code>).
                            <strong>Important:</strong> Add this directory/file to your <code>.gitignore</code> file (e.g., <code>/storage/app/google-analytics/</code>).
                            Enter the full, absolute path to this JSON file in the "Service Account Credentials JSON Path" field above.
                        </li>
                        <li>
                            <strong>Enter IDs:</strong> Fill in your "Google Analytics Measurement ID" (e.g., G-XXXXXXXXXX) and "Google Analytics Property ID" (the numeric ID for your GA4 property) in the fields above.
                        </li>
                    </ol>
                </div>
            </div>
        </div>

        <div class="flex justify-end">
            <button type="submit" class="inline-flex items-center px-6 py-3 bg-blue-600 border border-transparent rounded-md font-semibold text-sm text-white uppercase tracking-widest hover:bg-blue-700 active:bg-blue-800 focus:outline-none focus:border-blue-900 focus:ring-2 focus:ring-blue-500 focus:ring-offset-2 disabled:opacity-50 transition ease-in-out duration-150">
                Save Settings
            </button>
        </div>
    </form>
</div>
@endsection