{{-- This is a partial form for creating/editing LpPageSection --}}
{{-- Assumes $page, $section (LpPageSection instance), $sectionTypes, $availableLayouts are passed --}}

<div class="space-y-6">
    <div>
        <label for="section_title" class="block text-sm font-medium text-slate-700 dark:text-slate-300 mb-1">Section Title <span class="text-red-500">*</span></label>
        <input type="text" id="section_title" name="title" value="{{ old('title', $section->title ?? '') }}" required
               class="mt-1 block w-full rounded-md border-slate-300 dark:border-slate-600 shadow-sm focus:border-blue-500 focus:ring-blue-500 sm:text-sm dark:bg-slate-700 dark:text-slate-200 @error('title') border-red-500 @enderror">
        @error('title') <p class="mt-1 text-sm text-red-600 dark:text-red-400">{{ $message }}</p> @enderror
    </div>

    <div>
        <label for="section_type" class="block text-sm font-medium text-slate-700 dark:text-slate-300 mb-1">Section Type <span class="text-red-500">*</span></label>
        <select id="section_type" name="type" required
                class="mt-1 block w-full rounded-md border-slate-300 dark:border-slate-600 shadow-sm focus:border-blue-500 focus:ring-blue-500 sm:text-sm dark:bg-slate-700 dark:text-slate-200 @error('type') border-red-500 @enderror">
            <option value="">-- Select Type --</option>
            @foreach($sectionTypes as $typeKey => $typeName)
                <option value="{{ $typeKey }}" {{ (old('type', $section->type ?? '') == $typeKey) ? 'selected' : '' }}>
                    {{ $typeName }}
                </option>
            @endforeach
        </select>
        @error('type') <p class="mt-1 text-sm text-red-600 dark:text-red-400">{{ $message }}</p> @enderror
    </div>

    <div>
        <label for="section_layout" class="block text-sm font-medium text-slate-700 dark:text-slate-300 mb-1">
            Section Layout <span class="text-red-500">*</span>
        </label>
        <select id="section_layout" name="layout" required
                class="mt-1 block w-full rounded-md border-slate-300 dark:border-slate-600 shadow-sm focus:border-blue-500 focus:ring-blue-500 sm:text-sm dark:bg-slate-700 dark:text-slate-200 @error('layout') border-red-500 @enderror">
            <option value="">-- Select Layout --</option>
            @if(isset($availableLayouts) && is_array($availableLayouts))
                @foreach($availableLayouts as $layoutKey => $layoutName)
                    <option value="{{ $layoutKey }}" {{ (old('layout', $section->layout ?? 'default') == $layoutKey) ? 'selected' : '' }}>
                        {{ $layoutName }}
                    </option>
                @endforeach
            @else
                 <option value="default" {{ (old('layout', $section->layout ?? 'default') == 'default') ? 'selected' : '' }}>Default Layout</option>
            @endif
        </select>
        @error('layout') <p class="mt-1 text-sm text-red-600 dark:text-red-400">{{ $message }}</p> @enderror
        <p class="mt-1 text-xs text-slate-500 dark:text-slate-400">
            Choose how this section's content will be visually arranged.
        </p>
    </div>

    <div>
        <label for="section_sort_order" class="block text-sm font-medium text-slate-700 dark:text-slate-300 mb-1">Sort Order (Optional)</label>
        <input type="number" id="section_sort_order" name="sort_order" value="{{ old('sort_order', $section->sort_order ?? '') }}"
               class="mt-1 block w-full rounded-md border-slate-300 dark:border-slate-600 shadow-sm focus:border-blue-500 focus:ring-blue-500 sm:text-sm dark:bg-slate-700 dark:text-slate-200 @error('sort_order') border-red-500 @enderror"
               placeholder="Leave blank for auto-increment">
        @error('sort_order') <p class="mt-1 text-sm text-red-600 dark:text-red-400">{{ $message }}</p> @enderror
    </div>

    {{--
        Here you would typically include dynamic fields based on the selected 'Section Type'.
        This often involves JavaScript to show/hide relevant input fields for 'content'.
        For simplicity, we're assuming 'content' is handled as a JSON blob or by more advanced means.
        Example: <textarea name="content[text_content]" placeholder="Main text content..."></textarea>
    --}}
    <div class="mt-4 p-4 border border-dashed border-slate-300 dark:border-slate-600 rounded-md">
        <h4 class="text-sm font-medium text-slate-600 dark:text-slate-400 mb-2">Section Content Fields:</h4>
        <p class="text-xs text-slate-500 dark:text-slate-500">
            Content fields for this section (e.g., text, image URLs, button links) would appear here,
            dynamically based on the 'Section Type' selected. This often requires JavaScript.
            For now, manage content directly if your setup supports it, or implement dynamic forms.
            The 'content' field will be saved as a JSON object.
        </p>
        {{-- Example for a simple textarea to manually input JSON for content --}}
        <label for="section_content_json_temp" class="block text-sm font-medium text-slate-700 dark:text-slate-300 mb-1 mt-2">Content (JSON)</label>
        <textarea name="content_json_temp" id="section_content_json" rows="5"
                  class="mt-1 block w-full rounded-md border-slate-300 dark:border-slate-600 shadow-sm focus:border-blue-500 focus:ring-blue-500 sm:text-sm dark:bg-slate-700 dark:text-slate-200 font-mono text-xs"
                  placeholder='{ "field_name": "value", "another_field": "another_value" }'>{{ old('content_json_temp', isset($section->content) ? json_encode($section->content, JSON_PRETTY_PRINT) : '{}') }}</textarea>
        <input type="hidden" name="content" id="section_content_real">
        <script>
            document.addEventListener('DOMContentLoaded', function() {
                // Corrected ID to match the textarea's actual ID
                const jsonTextarea = document.getElementById('section_content_json'); // This was correct, the label was wrong.
                const realContentInput = document.getElementById('section_content_real');
                if (jsonTextarea && realContentInput) {
                    // Function to update the real input
                    function updateRealContentInput() {
                        try {
                            const parsedJson = JSON.parse(jsonTextarea.value || '{}');
                            realContentInput.value = JSON.stringify(parsedJson); // Store as stringified JSON
                        } catch (e) {
                            // Handle invalid JSON, maybe show an error
                            // For now, it will just not update the real input if JSON is invalid
                            console.warn("Invalid JSON in content textarea:", e.message);
                        }
                    }
                    // Initial update
                    updateRealContentInput();
                    // Update on change
                    jsonTextarea.addEventListener('input', updateRealContentInput);

                    // Ensure the form submits the parsed content
                    jsonTextarea.form.addEventListener('submit', function() {
                        updateRealContentInput(); // Ensure latest value is captured
                        // The 'content' field will be an array if parsed correctly by Laravel from stringified JSON
                    });
                }
            });
        </script>
        <p class="mt-1 text-xs text-slate-500 dark:text-slate-400">Enter content as a valid JSON object. This will be parsed and stored.</p>
        @error('content') <p class="mt-1 text-sm text-red-600 dark:text-red-400">{{ $message }}</p> @enderror
    </div>

</div>