{{--
    $index: Unique identifier for the section (e.g., existing ID or 'new_X')
    $section: LpPageSection instance (null for new sections)
    $sectionTypes: Array of available section types [key => Label]
    $availableLayouts: Array of available layouts [key => Label] (This needs to be passed to this partial)
--}}
@php
    $currentSection = $section ?? new \Modules\LandingPage\Entities\LpPageSection(); // Use a blank section for new items
    $isNew = !isset($section) || !$section->id; // Determine if it's a new section
@endphp
<div class="section-card" data-index="{{ $index }}">
    <input type="hidden" name="sections[{{ $index }}][id]" value="{{ $currentSection->id ?? '' }}">
    <div class="flex justify-between items-center mb-3">
        <h5 class="section-title-display text-lg font-semibold text-slate-700 dark:text-slate-200 flex items-center">
            <i class="fas fa-stream mr-2"></i> {{-- Icon for visual cue --}}
            @if($section && $section->type)
                {{ $sectionTypes[$section->type] ?? Str::title(str_replace(['-', '_'], ' ', $section->type)) }}
                @if($section->title)
                    <span class="text-sm text-slate-500 dark:text-slate-400 ml-2">- {{ $section->title }}</span>
                @endif
            @else
                New Section
            @endif
        </h5>
        <button type="button" class="remove-section-btn inline-flex items-center justify-center px-2 py-1 bg-red-500 border border-transparent rounded-md font-semibold text-xs text-white uppercase tracking-widest hover:bg-red-600 active:bg-red-700 focus:outline-none focus:border-red-700 focus:ring ring-red-300 disabled:opacity-25 transition ease-in-out duration-150">
            <i class="fas fa-trash-alt mr-1"></i> Remove
        </button>
    </div>

    <div class="grid grid-cols-1 md:grid-cols-12 gap-4">
        <div class="md:col-span-3">
            <label for="sections_{{ $index }}_type" class="block text-sm font-medium text-slate-700 dark:text-slate-300 mb-1">Type <span class="text-red-500">*</span></label>
            <select name="sections[{{ $index }}][type]" id="sections_{{ $index }}_type" class="section-type-select mt-1 block w-full rounded-md border-slate-300 dark:border-slate-600 shadow-sm focus:border-blue-500 focus:ring-blue-500 sm:text-sm dark:bg-slate-700 dark:text-slate-200" required data-content="{{ htmlspecialchars(json_encode($currentSection->content ?? new stdClass()), ENT_QUOTES, 'UTF-8') }}" data-current-type="{{ $currentSection->type ?? '' }}">
                <option value="">-- Select Type --</option>
                @foreach($sectionTypes as $key => $label)
                    <option value="{{ $key }}" {{ (old("sections.{$index}.type", $currentSection->type ?? '') == $key) ? 'selected' : '' }}>
                        {{ $label }}
                    </option>
                @endforeach
            </select>
        </div>

        <div class="md:col-span-3">
            <label for="sections_{{ $index }}_layout" class="block text-sm font-medium text-slate-700 dark:text-slate-300 mb-1">Layout <span class="text-red-500">*</span></label>
            <select name="sections[{{ $index }}][layout]" id="sections_{{ $index }}_layout" class="section-layout-select mt-1 block w-full rounded-md border-slate-300 dark:border-slate-600 shadow-sm focus:border-blue-500 focus:ring-blue-500 sm:text-sm dark:bg-slate-700 dark:text-slate-200" required>
                <option value="">-- Select Layout --</option>
                @if(isset($availableLayouts) && is_array($availableLayouts))
                    @foreach($availableLayouts as $layoutKey => $layoutName)
                        <option value="{{ $layoutKey }}" {{ (old("sections.{$index}.layout", $currentSection->layout ?? 'default') == $layoutKey) ? 'selected' : '' }}>
                            {{ $layoutName }}
                        </option>
                    @endforeach
                @else
                     <option value="default" {{ (old("sections.{$index}.layout", $currentSection->layout ?? 'default') == 'default') ? 'selected' : '' }}>Default Layout</option>
                @endif
            </select>
        </div>

        <div class="md:col-span-6">
            <label for="sections_{{ $index }}_title" class="block text-sm font-medium text-slate-700 dark:text-slate-300 mb-1">Section Title (Optional)</label>
            <input type="text" name="sections[{{ $index }}][title]" id="sections_{{ $index }}_title" value="{{ old("sections.{$index}.title", $currentSection->title ?? '') }}" class="mt-1 block w-full rounded-md border-slate-300 dark:border-slate-600 shadow-sm focus:border-blue-500 focus:ring-blue-500 sm:text-sm dark:bg-slate-700 dark:text-slate-200" placeholder="e.g., Our Awesome Services">
        </div>

        {{-- Sort order is typically handled by the main page form or drag-and-drop, not per section item directly here --}}
        {{-- If you need sort_order per section, you can add it back, but ensure your LpPageSection model and controller handle it --}}
        {{-- <div class="md:col-span-2">
            <label for="sections_{{ $index }}_sort_order" class="block text-sm font-medium text-slate-700 dark:text-slate-300 mb-1">Order</label>
            <input type="number" name="sections[{{ $index }}][sort_order]" id="sections_{{ $index }}_sort_order" value="{{ old("sections.{$index}.sort_order", ($section ? $section->sort_order : 0)) }}" class="mt-1 block w-full rounded-md border-slate-300 dark:border-slate-600 shadow-sm focus:border-blue-500 focus:ring-blue-500 sm:text-sm dark:bg-slate-700 dark:text-slate-200">
        </div> --}}

        <div class="md:col-span-12 content-fields-container mt-3 pt-3 border-t border-slate-200 dark:border-slate-600">
            {{-- Content fields will be rendered here by JavaScript --}}
            @if($errors->has("sections.{$index}.content"))
                <p class="text-sm text-red-600 dark:text-red-400 mt-1">Section content has errors.</p>
            @elseif($isNew || !$currentSection->type)
                <p class="text-slate-500 dark:text-slate-400">Select a section type to see its content fields.</p>
            @endif
        </div>
    </div>
</div>