{{--
    $section: The section object, if it exists.
    $index: The index for repeater fields.
    $content: The content of the section, if it exists.
--}}
@php
    $service = $item ?? []; // For existing items
    $serviceTitle = $service['title'] ?? '';
    $serviceDescription = $service['description'] ?? '';
    $serviceLink = $service['link'] ?? '';
    $visualType = $service['visual_type'] ?? 'icon'; // Default to icon
    $iconHtml = $service['icon_html'] ?? '';
    $imageUrl = $service['image_url'] ?? '';
@endphp

<div class="repeater-item space-y-3 p-4 border border-slate-200 dark:border-slate-600 rounded-md shadow-sm bg-slate-50 dark:bg-slate-700/50">
    <div class="flex justify-between items-center">
        <h4 class="text-md font-medium text-slate-700 dark:text-slate-200">Service Item</h4>
        <button type="button" class="text-red-500 hover:text-red-700 remove-repeater-item text-sm">
            <i class="fas fa-trash-alt mr-1"></i> Remove
        </button>
    </div>

    <div>
        <label class="block text-sm font-medium text-slate-700 dark:text-slate-300 mb-1">Title <span class="text-red-500">*</span></label>
        <input type="text" name="sections[{{ $sectionKey }}][content][services_list][{{ $index }}][title]" value="{{ old("sections.{$sectionKey}.content.services_list.{$index}.title", $serviceTitle) }}" required class="mt-1 block w-full rounded-md border-slate-300 dark:border-slate-600 shadow-sm focus:border-blue-500 focus:ring-blue-500 sm:text-sm dark:bg-slate-700 dark:text-slate-200">
    </div>
    <div>
        <label class="block text-sm font-medium text-slate-700 dark:text-slate-300 mb-1">Description <span class="text-red-500">*</span></label>
        <textarea name="sections[{{ $sectionKey }}][content][services_list][{{ $index }}][description]" rows="3" required class="mt-1 block w-full rounded-md border-slate-300 dark:border-slate-600 shadow-sm focus:border-blue-500 focus:ring-blue-500 sm:text-sm dark:bg-slate-700 dark:text-slate-200">{{ old("sections.{$sectionKey}.content.services_list.{$index}.description", $serviceDescription) }}</textarea>
    </div>
    <div>
        <label class="block text-sm font-medium text-slate-700 dark:text-slate-300 mb-1">Link URL (Optional)</label>
        <input type="url" name="sections[{{ $sectionKey }}][content][services_list][{{ $index }}][link]" value="{{ old("sections.{$sectionKey}.content.services_list.{$index}.link", $serviceLink) }}" class="mt-1 block w-full rounded-md border-slate-300 dark:border-slate-600 shadow-sm focus:border-blue-500 focus:ring-blue-500 sm:text-sm dark:bg-slate-700 dark:text-slate-200" placeholder="https://example.com/service">
    </div>

    <div>
        <label class="block text-sm font-medium text-slate-700 dark:text-slate-300 mb-1">Visual Type</label>
        <select name="sections[{{ $sectionKey }}][content][services_list][{{ $index }}][visual_type]"
                class="mt-1 block w-full rounded-md border-slate-300 dark:border-slate-600 shadow-sm focus:border-blue-500 focus:ring-blue-500 sm:text-sm dark:bg-slate-700 dark:text-slate-200 service-visual-type-selector-dynamic">
                {{-- data-index="{{ $index }}" is not strictly needed if JS uses closest('.repeater-item') --}}
            <option value="icon" {{ $visualType === 'icon' ? 'selected' : '' }}>Icon</option>
            <option value="image" {{ $visualType === 'image' ? 'selected' : '' }}>Image</option>
        </select>
    </div>

    <div class="service-icon-field-dynamic" style="{{ $visualType !== 'icon' ? 'display:none;' : '' }}">
        <label class="block text-sm font-medium text-slate-700 dark:text-slate-300 mb-1">Icon HTML/SVG or Class</label>
        <textarea name="sections[{{ $sectionKey }}][content][services_list][{{ $index }}][icon_html]" rows="3" class="mt-1 block w-full rounded-md border-slate-300 dark:border-slate-600 shadow-sm focus:border-blue-500 focus:ring-blue-500 sm:text-sm dark:bg-slate-700 dark:text-slate-200" placeholder='<svg>...</svg> or fas fa-icon'>{{ old("sections.{$sectionKey}.content.services_list.{$index}.icon_html", $iconHtml) }}</textarea>
        <p class="mt-1 text-xs text-slate-500 dark:text-slate-400">Paste your full SVG code or a FontAwesome class (e.g., `fas fa-rocket`).</p>
    </div>

    <div class="service-image-field-dynamic" style="{{ $visualType !== 'image' ? 'display:none;' : '' }}">
        <label class="block text-sm font-medium text-slate-700 dark:text-slate-300 mb-1">Service Image</label>
        <input type="file" name="sections[{{ $sectionKey }}][content][services_list][{{ $index }}][image_file]"
               class="mt-1 block w-full text-sm text-slate-500 dark:text-slate-400
                      file:mr-4 file:py-2 file:px-4
                      file:rounded-md file:border-0
                      file:text-sm file:font-semibold
                      file:bg-blue-50 file:text-blue-700 dark:file:bg-blue-700 dark:file:text-blue-100
                      hover:file:bg-blue-100 dark:hover:file:bg-blue-600 service-image-file-input dynamic-image-file-input"
               accept="image/*"
               data-item-index="{{ $index }}"
               data-list-name="services_list"
               data-field-name="image"
               data-preview-class="service-image-preview">
        <input type="hidden" name="sections[{{ $sectionKey }}][content][services_list][{{ $index }}][existing_image_url]" value="{{ $imageUrl }}">

        <div class="mt-2 service-image-preview-{{ $index }}">
            @if($imageUrl)
                <img src="{{ asset('storage/' . $imageUrl) }}" alt="Current Image" class="max-h-32 rounded shadow mb-2">
                <label class="inline-flex items-center text-xs text-slate-600 dark:text-slate-400"><input type="checkbox" name="sections[{{ $sectionKey }}][content][services_list][{{ $index }}][remove_image]" value="1" class="form-checkbox rounded text-blue-500 mr-1"> Remove current image</label>
            @else
                <span class="text-xs text-slate-500 dark:text-slate-400">No image selected.</span>
            @endif
        </div>
    </div>
</div>
