<script>
document.addEventListener('DOMContentLoaded', function () {
    const mainMenuList = document.getElementById('menu-items-list');

    if (mainMenuList) {
        const initializeSortable = (listElement) => {
            new Sortable(listElement, {
                group: 'nested-menu-items', // Shared group name allows dragging between lists
                animation: 150,
                fallbackOnBody: true,
                swapThreshold: 0.65,
                handle: '.drag-handle', // Use a specific handle if defined, otherwise whole item
                ghostClass: 'sortable-ghost', // Class for the drop placeholder
                chosenClass: 'sortable-chosen', // Class for the chosen item
                dragClass: 'sortable-drag', // Class for the dragging item
                onEnd: function (evt) {
                    // evt.item: dragged HTMLElement
                    // evt.to: target list
                    // evt.from: old list
                    // evt.oldIndex: old index within old parent
                    // evt.newIndex: new index within new parent
                    // evt.oldDraggableIndex: old index within old parent, only counting draggable items
                    // evt.newDraggableIndex: new index within new parent, only counting draggable items
                    // evt.clone: the clone element
                    // evt.pullMode: when item is dragged from one list into another
                    saveMenuOrder();
                }
            });
        };

        // Initialize sortable on the main list
        initializeSortable(mainMenuList);

        // Initialize sortable on all existing and future sub-menu lists
        // This requires sub-menu ULs to have the class 'sub-menu-items-list'
        // The menu-item-display partial uses 'nested-menu-items-list'.
        const subMenuLists = mainMenuList.querySelectorAll('ul.nested-menu-items-list');
        subMenuLists.forEach(list => initializeSortable(list));

        // If you dynamically add sub-menus, you might need to re-initialize sortable on them.
        // For now, this covers initially loaded sub-menus.
    }

    function serializeMenuOrder() {
        const items = [];
        const processList = (listElement, parentId) => {
            Array.from(listElement.children).forEach((itemLi, index) => {
                if (itemLi.matches('li[data-id]')) { // Ensure it's a menu item LI with data-id
                    const itemId = itemLi.dataset.id;
                    items.push({
                        id: parseInt(itemId),
                        order: index,
                        parent_id: parentId ? parseInt(parentId) : null
                    });

                    // Process nested list if it exists
                    const subList = itemLi.querySelector('ul.nested-menu-items-list');
                    if (subList) {
                        processList(subList, itemId);
                    }
                }
            });
        };

        if (mainMenuList) {
            processList(mainMenuList, null);
        }
        return items;
    }

    function saveMenuOrder() {
        const orderedItems = serializeMenuOrder();
        // console.log('Serialized Order:', orderedItems); // For debugging

        // Use the global variables defined in edit.blade.php
        fetch(menuReorderUrl, {
            method: 'POST',
            headers: {
                'Content-Type': 'application/json',
                'X-CSRF-TOKEN': csrfToken,
                'Accept': 'application/json'
            },
            body: JSON.stringify({ items: orderedItems })
        })
        .then(response => response.json())
        .then(data => {
            if (data.success) {
                // console.log('Order saved successfully:', data.message);
                // You could show a more permanent success message here
                // For example, using a toast notification library or updating a status div
                alert(data.message || 'Menu order saved!'); // Simple feedback
            } else {
                console.error('Failed to save order:', data.message);
                alert('Error saving menu order: ' + (data.message || 'Unknown error'));
            }
        })
        .catch(error => {
            console.error('Error during fetch:', error);
            alert('An error occurred while saving the menu order. Check the console for details.');
        });
    }
});
</script>