<?php

namespace Modules\LandingPage\Database\Seeders;

use Illuminate\Database\Seeder;
use Modules\LandingPage\Entities\LpPage;

class LpPageSeeder extends Seeder
{
    /**
     * Run the database seeds.
     *
     * @return void
     */
    public function run()
    {
        $pages = [
            [
                'title' => 'Home',
                'slug' => setting('landingpage_homepage_slug', 'home'), // Use setting or default
                'content' => '<p class="text-xl md:text-2xl mb-10 max-w-2xl mx-auto text-gray-200 dark:text-gray-300">Welcome to Digital Vocano! We craft innovative digital solutions to elevate your business and engage your audience. Explore what we can do for you.</p>',
                'meta_title' => 'Welcome to ' . setting('site_name', 'Digital Vocano'),
                'meta_description' => 'Discover innovative digital solutions at ' . setting('site_name', 'Digital Vocano') . '. We specialize in web development, AI, and more.',
                'meta_keywords' => 'digital solutions, web development, innovation, ' . strtolower(setting('site_name', 'Digital Vocano')),
                'is_published' => true,
                'sort_order' => 0,
            ],
            [
                'title' => 'About Us',
                'slug' => 'about-us',
                'content' => '<h1>About Our Company</h1><p>We are a passionate team dedicated to creating impactful digital experiences. Learn more about our journey, mission, and the values that drive us forward.</p><h2>Our Mission</h2><p>To empower businesses with transformative technology and creative strategies.</p><h2>Our Team</h2><p>Meet the talented individuals behind our success...</p>',
                'meta_title' => 'About Us - ' . setting('site_name', 'Digital Vocano'),
                'meta_description' => 'Learn about the team, mission, and values of ' . setting('site_name', 'Digital Vocano') . '.',
                'meta_keywords' => 'about us, company, team, mission, values',
                'is_published' => true,
                'sort_order' => 10,
            ],
            [
                'title' => 'Our Services',
                'slug' => 'services',
                'content' => '<h1>Our Services</h1><p>We offer a comprehensive suite of services to meet your digital needs. From custom software development to strategic digital marketing, we have you covered.</p><ul><li>Custom Web Development</li><li>AI & Machine Learning Solutions</li><li>Mobile Application Development</li><li>UI/UX Design</li><li>Digital Marketing & SEO</li></ul>',
                'meta_title' => 'Our Services - ' . setting('site_name', 'Digital Vocano'),
                'meta_description' => 'Explore the range of services offered by ' . setting('site_name', 'Digital Vocano') . ', including web development, AI solutions, and digital marketing.',
                'meta_keywords' => 'services, web development, ai, mobile apps, ui/ux, digital marketing',
                'is_published' => true,
                'sort_order' => 20,
            ],
            [
                'title' => 'Contact Us',
                'slug' => 'contact',
                'content' => '<h1>Get In Touch</h1><p>We\'d love to hear from you! Whether you have a question about our services, want to discuss a project, or just want to say hello, please reach out.</p><p><strong>Email:</strong> <a href="mailto:'.setting('contact_email', 'info@example.com').'">'.setting('contact_email', 'info@example.com').'</a></p><p><strong>Phone:</strong> '.setting('contact_phone', '+1 234 567 890').'</p><p>You can also fill out the contact form on our website (if you add one).</p>',
                'meta_title' => 'Contact Us - ' . setting('site_name', 'Digital Vocano'),
                'meta_description' => 'Contact ' . setting('site_name', 'Digital Vocano') . ' for inquiries, project discussions, or any questions you may have.',
                'meta_keywords' => 'contact, get in touch, support, inquiry',
                'is_published' => true,
                'sort_order' => 30,
            ],
            [
                'title' => 'Privacy Policy',
                'slug' => 'privacy-policy',
                'content' => '<h1>Privacy Policy</h1><p>Your privacy is important to us. This privacy statement explains the personal data ' . setting('site_name', 'Digital Vocano') . ' processes, how ' . setting('site_name', 'Digital Vocano') . ' processes it, and for what purposes.</p><p>[...Detailed privacy policy content...]</p>',
                'meta_title' => 'Privacy Policy - ' . setting('site_name', 'Digital Vocano'),
                'meta_description' => 'Read the privacy policy for ' . setting('site_name', 'Digital Vocano') . '.',
                'meta_keywords' => 'privacy policy, data protection, legal',
                'is_published' => true,
                'sort_order' => 100,
            ],
            [
                'title' => 'Terms of Service',
                'slug' => 'terms-of-service',
                'content' => '<h1>Terms of Service</h1><p>Please read these terms of service carefully before using Our Service operated by ' . setting('site_name', 'Digital Vocano') . '.</p><p>[...Detailed terms of service content...]</p>',
                'meta_title' => 'Terms of Service - ' . setting('site_name', 'Digital Vocano'),
                'meta_description' => 'Read the terms of service for ' . setting('site_name', 'Digital Vocano') . '.',
                'meta_keywords' => 'terms of service, conditions, legal',
                'is_published' => true,
                'sort_order' => 110,
            ],
        ];

        foreach ($pages as $pageData) {
            LpPage::updateOrCreate(['slug' => $pageData['slug']], $pageData);
        }

        $this->command->info('Landing page default pages seeded successfully!');
    }
}