<?php

namespace Modules\LandingPage\Database\Seeders;

use Illuminate\Database\Seeder;
use Spatie\Permission\Models\Permission;
use Spatie\Permission\Models\Role;
use Spatie\Permission\PermissionRegistrar;

class LandingPagePermissionsSeeder extends Seeder
{
    /**
     * Run the database seeds.
     *
     * @return void
     */
    public function run()
    {
        // Reset cached roles and permissions
        app()[PermissionRegistrar::class]->forgetCachedPermissions();

        // Define permissions for LpPage
        $permissions = [
            'view any lppages',
            'view lppages',
            'create lppages',
            'update lppages',
            'delete lppages',
            // Add more specific permissions if needed, e.g., 'publish lppages'
        ];

        foreach ($permissions as $permission) {
            Permission::firstOrCreate(['name' => $permission, 'guard_name' => 'web']);
            // If you use API guards like sanctum and want these permissions for API too:
            // Permission::firstOrCreate(['name' => $permission, 'guard_name' => 'sanctum']);
        }

        // Create roles and assign existing permissions

        // Editor Role - Can manage most aspects of landing pages
        $editorRole = Role::firstOrCreate(['name' => 'editor', 'guard_name' => 'web']);
        $editorRole->givePermissionTo([
            'view any lppages',
            'view lppages',
            'create lppages',
            'update lppages',
        ]);
        // Note: We are not giving 'delete lppages' to the editor by default in this example.

        // Admin Role - Super admin, can do anything
        // It's common for admins to have all permissions implicitly via a Gate::before check
        // or by assigning all permissions.
        $adminRole = Role::firstOrCreate(['name' => 'admin', 'guard_name' => 'web']);
        // Option 1: Give all defined permissions (if you don't have a Gate::before for admins)
        // $adminRole->givePermissionTo(Permission::where('guard_name', 'web')->get());
        // Option 2: Or, more specifically, give all LpPage permissions
        $adminRole->givePermissionTo($permissions);


        $this->command->info('LandingPage permissions and roles seeded successfully.');
    }
}