<?php

namespace Modules\LandingPage\Providers;

// use Illuminate\Cache\RateLimiting\Limit; // Not used in this context
use Illuminate\Foundation\Support\Providers\RouteServiceProvider as ServiceProvider;
// use Illuminate\Http\Request; // Not used in this context
// use Illuminate\Support\Facades\RateLimiter; // Not used in this context
use Illuminate\Support\Facades\Route;

class RouteServiceProvider extends ServiceProvider
{
    /**
     * The module namespace to assume when generating URLs to actions.
     *
     * @var string
     */
    protected string $moduleNamespace = 'Modules\LandingPage\Http\Controllers';

    protected string $moduleName = 'LandingPage';
    // protected string $moduleNameLower = 'landingpage'; // Not strictly needed here

    /**
     * Define your route model bindings, pattern filters, and other route configuration.
     */
    public function boot(): void
    {
        parent::boot(); // Call the parent boot method
    }

    /**
     * Define the routes for the module.
     *
     * @return void
     */
    public function map(): void
    {
        $this->mapApiRoutes();
        $this->mapWebRoutes();
        // $this->mapAdminRoutes(); // CRITICAL: DO NOT map admin routes here.
    }

    protected function mapWebRoutes(): void
    {
        Route::middleware('web')
            ->namespace($this->moduleNamespace) // Assuming FrontendPageController is directly under Http/Controllers
            ->group(module_path($this->moduleName, '/Routes/web.php'));
    }

    // The mapAdminRoutes() method should be REMOVED or COMMENTED OUT entirely
    /*
    protected function mapAdminRoutes(): void
    {
        $this->routes(function () {
            Route::middleware('web')
                 ->namespace($this->moduleNamespace . '\Admin')
                 ->group(module_path($this->moduleName, '/Routes/admin.php'));
        });
    }
    */

    protected function mapApiRoutes(): void
    {
        Route::middleware('api')
            ->namespace($this->moduleNamespace)
            ->group(module_path($this->moduleName, '/Routes/api.php'));
    }
}
