<?php

namespace Modules\LandingPage\Http\Requests;

use Illuminate\Foundation\Http\FormRequest;

class UpdateLpPageApiRequest extends FormRequest
{
    public function authorize()
    {
        // Add authorization logic here, e.g., check if user can update this specific page
        return true; // Or auth()->user()->can('update_lppage', $this->route('landingpage'));
    }

    public function rules()
    {
        $pageId = $this->route('landingpage') ? $this->route('landingpage')->id : null;
        return [
            'title' => 'sometimes|required|string|max:255',
            'slug' => 'sometimes|nullable|string|max:255|unique:lp_pages,slug,' . $pageId,
            'content' => 'sometimes|nullable|string',
            'meta_title' => 'sometimes|nullable|string|max:255',
            'meta_description' => 'sometimes|nullable|string|max:500',
            'meta_keywords' => 'sometimes|nullable|string|max:255',
            'theme_template' => 'sometimes|nullable|string|max:255',
            'is_published' => 'sometimes|boolean',
            'sort_order' => 'sometimes|integer',
        ];
    }
}
