<?php

namespace Modules\LandingPage\Providers;

// use Illuminate\Cache\RateLimiting\Limit; // Not used in this context
use Illuminate\Foundation\Support\Providers\RouteServiceProvider as ServiceProvider;
// use Illuminate\Http\Request; // Not used in this context
// use Illuminate\Support\Facades\RateLimiter; // Not used in this context
use Illuminate\Support\Facades\Route;

class RouteServiceProvider extends ServiceProvider
{
    /**
     * The module namespace to assume when generating URLs to actions.
     *
     * @var string
     */
    protected string $moduleNamespace = 'Modules\LandingPage\Http\Controllers';

    protected string $name = 'LandingPage'; // Changed from moduleName to name to match usage
    // protected string $moduleNameLower = 'landingpage'; // Not strictly needed here

    /**
     * Define your route model bindings, pattern filters, and other route configuration.
     */
    public function boot(): void
    {
        parent::boot(); // Call the parent boot method
    }

    /**
     * Define the routes for the module.
     *
     * @return void
     */
    public function map(): void
    {
        $this->mapApiRoutes();
        $this->mapWebRoutes(); // Ensure this is uncommented
        $this->mapAdminRoutes(); 
    }

    protected function mapWebRoutes(): void
    {
        // The main app's RouteServiceProvider already applies the 'web' middleware.
        // This ensures controllers in web.php are correctly namespaced.
        Route::middleware('web') // Ensures the group call is valid and context is clear
            ->namespace($this->moduleNamespace) // Assuming FrontendPageController is directly under Http/Controllers
            ->group(module_path($this->name, '/routes/web.php'));
    }

    protected function mapApiRoutes(): void
    {
        // This configuration assumes this module's RouteServiceProvider is fully
        // responsible for its API routes, including prefixing and base middleware,
        // especially if the main app's RouteServiceProvider is set to skip this module's API files.
        Route::prefix('api/' . strtolower($this->name)) // e.g., api/landingpage
            ->middleware('api') // Apply base API middleware
            ->as('api.' . strtolower($this->name) . '.') // e.g., api.landingpage.
            ->namespace($this->moduleNamespace) // API controllers are in the root of Http/Controllers for this module
            ->group(module_path($this->name, '/routes/api.php'));
    }

    /**
     * Define the "admin" routes for the module.
     *
     * These routes are typically stateless.
     */
    protected function mapAdminRoutes(): void
    {
        Route::middleware(['web', \App\Http\Middleware\IsAdminMiddleware::class]) // Apply necessary middleware
             ->prefix('admin/' . strtolower($this->name)) // e.g., admin/landingpage
             ->as('admin.' . strtolower($this->name) . '.')     // e.g., admin.landingpage.
             ->namespace($this->moduleNamespace . '\\Admin')  // For Admin controllers
             ->group(module_path($this->name, '/routes/admin.php'));
    }
}
