@extends('layouts.app') {{-- Or your main frontend layout --}}

@section('title', $project->name . ' - ' . setting('app_name', 'Digital Vocano'))

@section('content')
<div class="container mx-auto px-4 py-8">
    <div class="mb-8">
        <a href="{{ route('digitalvocano.projects.list') }}" class="text-purple-600 dark:text-purple-400 hover:text-purple-800 dark:hover:text-purple-200 font-medium transition duration-150 ease-in-out">
            &larr; Back to All Projects
        </a>
    </div>

    <article class="bg-white dark:bg-gray-800 shadow-xl rounded-lg overflow-hidden">
        @if($project->featured_image_url)
            <img src="{{ $project->featured_image_url }}" alt="{{ $project->name }}" class="w-full h-64 md:h-96 object-cover">
        @endif

        <div class="p-6 md:p-10">
            <h1 class="text-4xl lg:text-5xl font-bold mb-6 text-gray-900 dark:text-white">{{ $project->name }}</h1>

            @if($project->short_description)
                <p class="text-xl text-gray-600 dark:text-gray-400 mb-8">{{ $project->short_description }}</p>
            @endif

            <div class="prose prose-lg dark:prose-invert max-w-none text-gray-700 dark:text-gray-300 mb-10">
                {!! nl2br(e($project->full_description)) !!} {{-- Basic display, consider Markdown parsing for richer content --}}
            </div>

            <div class="flex flex-wrap gap-4 mb-10">
                @if($project->store_url)
                    <a href="{{ $project->store_url }}" target="_blank" class="inline-block px-8 py-3 bg-green-500 text-white font-semibold rounded-lg shadow-md hover:bg-green-600 focus:outline-none focus:ring-2 focus:ring-green-500 focus:ring-opacity-50 transition duration-150">View on Store</a>
                @endif
                @if($project->demo_url)
                    <a href="{{ $project->demo_url }}" target="_blank" class="inline-block px-8 py-3 bg-blue-500 text-white font-semibold rounded-lg shadow-md hover:bg-blue-600 focus:outline-none focus:ring-2 focus:ring-blue-500 focus:ring-opacity-50 transition duration-150">Live Demo</a>
                @endif
            </div>

            @if($project->internal_documentation_content)
                <section class="mt-12 pt-8 border-t border-gray-200 dark:border-gray-700">
                    <h2 class="text-3xl font-semibold mb-6 text-gray-800 dark:text-gray-100">Documentation</h2>
                    <div class="prose prose-lg dark:prose-invert max-w-none text-gray-700 dark:text-gray-300 bg-gray-50 dark:bg-gray-700 p-6 rounded-md">
                        {!! nl2br(e($project->internal_documentation_content)) !!} {{-- Basic display, consider Markdown parsing --}}
                    </div>
                </section>
            @endif
        </div>
    </article>
</div>
@endsection
