@extends('layouts.app') {{-- Or your main frontend layout --}}

@section('content')
<div class="container mx-auto px-4 py-8">
    <h1 class="text-4xl font-bold text-center mb-10 text-gray-800 dark:text-gray-100">{{ setting('digitalvocano_portfolio_title', 'Our Projects') }}</h1>

    @if($projects->isEmpty())
        <p class="text-center text-gray-600 dark:text-gray-400 text-lg">No projects available at the moment. Check back soon!</p>
    @else
        <div class="grid grid-cols-1 md:grid-cols-2 lg:grid-cols-3 gap-8">
            @foreach ($projects as $project)
                <div class="bg-white dark:bg-gray-800 rounded-xl shadow-2xl overflow-hidden transform hover:scale-105 transition-transform duration-300 ease-in-out">
                    @if($project->featured_image_url)
                        <a href="{{ route('digitalvocano.projects.show', $project->slug) }}">
                            <img src="{{ $project->featured_image_url }}" alt="{{ $project->name }}" class="w-full h-56 object-cover">
                        </a>
                    @else
                         <a href="{{ route('digitalvocano.projects.show', $project->slug) }}" class="block w-full h-56 bg-gray-200 dark:bg-gray-700 flex items-center justify-center text-gray-400 dark:text-gray-500">
                            <svg class="w-16 h-16" fill="none" stroke="currentColor" viewBox="0 0 24 24" xmlns="http://www.w3.org/2000/svg"><path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M4 16l4.586-4.586a2 2 0 012.828 0L16 16m-2-2l1.586-1.586a2 2 0 012.828 0L20 14m-6-6h.01M6 20h12a2 2 0 002-2V6a2 2 0 00-2-2H6a2 2 0 00-2 2v12a2 2 0 002 2z"></path></svg>
                            <span class="sr-only">No image available</span>
                        </a>
                    @endif
                    <div class="p-6">
                        <h2 class="text-2xl font-semibold mb-3 text-gray-800 dark:text-white">{{ $project->name }}</h2>
                        <p class="text-gray-600 dark:text-gray-400 text-sm mb-4 min-h-[3em] line-clamp-2">{{ $project->short_description ?: 'No description available.' }}</p>
                        <a href="{{ route('digitalvocano.projects.show', $project->slug) }}" class="inline-block bg-purple-600 hover:bg-purple-700 text-white font-semibold py-2 px-4 rounded-lg transition duration-300 ease-in-out">
                            View Details &rarr;
                        </a>
                    </div>
                </div>
            @endforeach
        </div>

        <div class="mt-8">
            {{ $projects->links() }}
        </div>
    @endif
</div>
@endsection
