@extends('layouts.admin')

@section('title', 'Project Details: ' . $project->name)
@section('header_title', 'Project Details: ' . $project->name)

@section('content')
<div class="mb-4">
    <a href="{{ route('admin.digitalvocano.projects.index') }}" class="text-purple-600 hover:text-purple-800 dark:text-purple-400 dark:hover:text-purple-200">&larr; Back to Projects</a>
</div>

<div class="bg-white dark:bg-gray-800 overflow-hidden shadow-xl sm:rounded-lg">
    <div class="p-6 lg:p-8">
        <h3 class="text-xl font-semibold text-gray-800 dark:text-gray-200 mb-4">{{ $project->name }}</h3>

        @if($project->featured_image_url)
            <img src="{{ $project->featured_image_url }}" alt="{{ $project->name }}" class="mb-4 rounded-lg max-h-60 object-contain">
        @endif

        <div class="prose dark:prose-invert max-w-none text-gray-700 dark:text-gray-300">
            <p><strong>Slug:</strong> {{ $project->slug }}</p>
            <p><strong>Published:</strong> <span class="px-2 py-1 text-xs font-semibold leading-tight {{ $project->is_published ? 'text-green-700 bg-green-100 dark:bg-green-700 dark:text-green-100' : 'text-red-700 bg-red-100 dark:text-red-100 dark:bg-red-700' }} rounded-full">{{ $project->is_published ? 'Yes' : 'No' }}</span></p>
            <p><strong>Sort Order:</strong> {{ $project->sort_order }}</p>

            @if($project->short_description)
                <h4 class="font-semibold mt-4 text-gray-800 dark:text-gray-200">Short Description:</h4>
                <p>{{ $project->short_description }}</p>
            @endif

            @if($project->full_description)
                <h4 class="font-semibold mt-4 text-gray-800 dark:text-gray-200">Full Description:</h4>
                <div>{!! nl2br(e($project->full_description)) !!}</div> {{-- Basic display, consider Markdown parsing if using Markdown --}}
            @endif

            <h4 class="font-semibold mt-4 text-gray-800 dark:text-gray-200">Links:</h4>
            <ul>
                @if($project->store_url)<li><strong>Store:</strong> <a href="{{ $project->store_url }}" target="_blank" class="text-purple-600 hover:underline dark:text-purple-400 dark:hover:text-purple-300">{{ $project->store_url }}</a></li>@endif
                @if($project->demo_url)<li><strong>Demo:</strong> <a href="{{ $project->demo_url }}" target="_blank" class="text-purple-600 hover:underline dark:text-purple-400 dark:hover:text-purple-300">{{ $project->demo_url }}</a></li>@endif
            </ul>

            @if($project->internal_documentation_content)
                <h4 class="font-semibold mt-4 text-gray-800 dark:text-gray-200">Internal Documentation:</h4>
                <div class="p-4 border rounded-md dark:border-gray-700 mt-2 bg-gray-50 dark:bg-gray-700">{!! nl2br(e($project->internal_documentation_content)) !!}</div> {{-- Basic display --}}
            @endif
        </div>

        <div class="mt-6">
            <a href="{{ route('admin.digitalvocano.projects.edit', $project) }}" class="px-4 py-2 text-sm font-medium leading-5 text-white transition-colors duration-150 bg-purple-600 border border-transparent rounded-lg active:bg-purple-600 hover:bg-purple-700 focus:outline-none focus:shadow-outline-purple">Edit Project</a>
        </div>
    </div>
</div>
@endsection
