<div class="grid grid-cols-1 md:grid-cols-2 gap-6">
    <div>
        <label for="name" class="block text-sm font-medium text-gray-700 dark:text-gray-300">Project Name <span class="text-red-500">*</span></label>
        <input type="text" name="name" id="name" value="{{ old('name', $project->name ?? '') }}" required
               class="mt-1 block w-full shadow-sm sm:text-sm border-gray-300 dark:border-gray-600 dark:bg-gray-700 dark:text-gray-100 rounded-md focus:ring-indigo-500 focus:border-indigo-500">
        @error('name') <p class="mt-2 text-sm text-red-600 dark:text-red-400">{{ $message }}</p> @enderror
    </div>

    <div>
        <label for="slug" class="block text-sm font-medium text-gray-700 dark:text-gray-300">Slug (URL friendly)</label>
        <input type="text" name="slug" id="slug" value="{{ old('slug', $project->slug ?? '') }}"
               class="mt-1 block w-full shadow-sm sm:text-sm border-gray-300 dark:border-gray-600 dark:bg-gray-700 dark:text-gray-100 rounded-md focus:ring-indigo-500 focus:border-indigo-500"
               placeholder="Leave blank to auto-generate">
        @error('slug') <p class="mt-2 text-sm text-red-600 dark:text-red-400">{{ $message }}</p> @enderror
    </div>

    <div class="md:col-span-2">
        <label for="short_description" class="block text-sm font-medium text-gray-700 dark:text-gray-300">Short Description</label>
        <textarea name="short_description" id="short_description" rows="3"
                  class="mt-1 block w-full shadow-sm sm:text-sm border-gray-300 dark:border-gray-600 dark:bg-gray-700 dark:text-gray-100 rounded-md focus:ring-indigo-500 focus:border-indigo-500">{{ old('short_description', $project->short_description ?? '') }}</textarea>
        @error('short_description') <p class="mt-2 text-sm text-red-600 dark:text-red-400">{{ $message }}</p> @enderror
    </div>

    <div class="md:col-span-2">
        <label for="full_description" class="block text-sm font-medium text-gray-700 dark:text-gray-300">Full Description</label>
        {{-- Consider using a WYSIWYG editor for this field --}}
        <textarea name="full_description" id="full_description" rows="6"
                  class="mt-1 block w-full shadow-sm sm:text-sm border-gray-300 dark:border-gray-600 dark:bg-gray-700 dark:text-gray-100 rounded-md focus:ring-indigo-500 focus:border-indigo-500">{{ old('full_description', $project->full_description ?? '') }}</textarea>
        @error('full_description') <p class="mt-2 text-sm text-red-600 dark:text-red-400">{{ $message }}</p> @enderror
    </div>

    <div>
        <label for="featured_image_file" class="block text-sm font-medium text-gray-700 dark:text-gray-300">Featured Image</label>
        <input type="file" name="featured_image_file" id="featured_image_file"
               class="mt-1 block w-full text-sm text-gray-500 dark:text-gray-400 file:mr-4 file:py-2 file:px-4 file:rounded-full file:border-0 file:text-sm file:font-semibold file:bg-purple-50 dark:file:bg-purple-700 file:text-purple-700 dark:file:text-purple-100 hover:file:bg-purple-100 dark:hover:file:bg-purple-600">
        @error('featured_image_file') <p class="mt-2 text-sm text-red-600 dark:text-red-400">{{ $message }}</p> @enderror
        @if(isset($project) && $project->featured_image_url)
            <div class="mt-2">
                <img src="{{ $project->featured_image_url }}" alt="{{ $project->name }}" class="h-20 rounded">
                <p class="text-xs text-gray-500 dark:text-gray-400">Current image</p>
            </div>
        @endif
    </div>

    <div>
        <label for="store_url" class="block text-sm font-medium text-gray-700 dark:text-gray-300">Store URL</label>
        <input type="url" name="store_url" id="store_url" value="{{ old('store_url', $project->store_url ?? '') }}"
               class="mt-1 block w-full shadow-sm sm:text-sm border-gray-300 dark:border-gray-600 dark:bg-gray-700 dark:text-gray-100 rounded-md focus:ring-indigo-500 focus:border-indigo-500">
        @error('store_url') <p class="mt-2 text-sm text-red-600 dark:text-red-400">{{ $message }}</p> @enderror
    </div>

    <div>
        <label for="demo_url" class="block text-sm font-medium text-gray-700 dark:text-gray-300">Demo URL</label>
        <input type="url" name="demo_url" id="demo_url" value="{{ old('demo_url', $project->demo_url ?? '') }}"
               class="mt-1 block w-full shadow-sm sm:text-sm border-gray-300 dark:border-gray-600 dark:bg-gray-700 dark:text-gray-100 rounded-md focus:ring-indigo-500 focus:border-indigo-500">
        @error('demo_url') <p class="mt-2 text-sm text-red-600 dark:text-red-400">{{ $message }}</p> @enderror
    </div>

    <div class="md:col-span-2">
        <label for="internal_documentation_content" class="block text-sm font-medium text-gray-700 dark:text-gray-300">Internal Documentation Content</label>
        {{-- Consider using a WYSIWYG editor for this field --}}
        <textarea name="internal_documentation_content" id="internal_documentation_content" rows="10"
                  class="mt-1 block w-full shadow-sm sm:text-sm border-gray-300 dark:border-gray-600 dark:bg-gray-700 dark:text-gray-100 rounded-md focus:ring-indigo-500 focus:border-indigo-500">{{ old('internal_documentation_content', $project->internal_documentation_content ?? '') }}</textarea>
        @error('internal_documentation_content') <p class="mt-2 text-sm text-red-600 dark:text-red-400">{{ $message }}</p> @enderror
    </div>

    <div>
        <label for="sort_order" class="block text-sm font-medium text-gray-700 dark:text-gray-300">Sort Order</label>
        <input type="number" name="sort_order" id="sort_order" value="{{ old('sort_order', $project->sort_order ?? 0) }}"
               class="mt-1 block w-full shadow-sm sm:text-sm border-gray-300 dark:border-gray-600 dark:bg-gray-700 dark:text-gray-100 rounded-md focus:ring-indigo-500 focus:border-indigo-500">
        @error('sort_order') <p class="mt-2 text-sm text-red-600 dark:text-red-400">{{ $message }}</p> @enderror
    </div>

    <div>
        <label for="is_published" class="flex items-center cursor-pointer mt-6">
            <div class="relative">
                <input type="checkbox" id="is_published" name="is_published" class="sr-only" value="1" {{ old('is_published', isset($project) && $project->is_published ? '1' : '0') == '1' ? 'checked' : '' }}>
                <div class="block bg-gray-600 dark:bg-gray-700 w-14 h-8 rounded-full"></div>
                <div class="dot absolute left-1 top-1 bg-white w-6 h-6 rounded-full transition"></div>
            </div>
            <div class="ml-3 text-gray-700 dark:text-gray-300 font-medium">
                Published
            </div>
        </label>
        @error('is_published') <p class="mt-2 text-sm text-red-600 dark:text-red-400">{{ $message }}</p> @enderror
    </div>
</div>

<div class="mt-8 flex justify-end">
    <a href="{{ route('admin.digitalvocano.projects.index') }}" class="mr-3 inline-flex items-center px-4 py-2 bg-white dark:bg-gray-800 border border-gray-300 dark:border-gray-500 rounded-md font-semibold text-xs text-gray-700 dark:text-gray-300 uppercase tracking-widest shadow-sm hover:bg-gray-50 dark:hover:bg-gray-700 focus:outline-none focus:ring-2 focus:ring-indigo-500 focus:ring-offset-2 dark:focus:ring-offset-gray-800 disabled:opacity-25 transition ease-in-out duration-150">
        Cancel
    </a>
    <button type="submit" class="inline-flex items-center px-4 py-2 bg-purple-600 border border-transparent rounded-md font-semibold text-xs text-white uppercase tracking-widest hover:bg-purple-700 active:bg-purple-900 focus:outline-none focus:border-purple-900 focus:ring ring-purple-300 disabled:opacity-25 transition ease-in-out duration-150">
        {{ isset($project) ? 'Update Project' : 'Create Project' }}
    </button>
</div>

<style>
    /* Simple toggle switch style from previous examples */
    input:checked ~ .dot { transform: translateX(100%); background-color: #48bb78; } /* Tailwind green-500 */
    input:checked ~ .block { background-color: #a0aec0; } /* Tailwind gray-400 */
    /* Dark mode for toggle */
    .dark input:checked ~ .dot { background-color: #38a169; } /* Tailwind green-600 */
    .dark input:checked ~ .block { background-color: #4a5568; } /* Tailwind gray-600 */
</style>
