<?php

use Illuminate\Support\Facades\Route;
use Modules\Blog\Http\Controllers\Frontend\BlogController;

/*
|--------------------------------------------------------------------------
| Web Routes
|--------------------------------------------------------------------------
|
| Here is where you can register web routes for your application. These
| routes are loaded by the RouteServiceProvider within a group which
| contains the "web" middleware group. Now create something great!
|
*/

Route::group(['as' => 'frontend.blog.'], function () { // Name prefix for frontend routes
    Route::get('/blog', [BlogController::class, 'index'])->name('index');
    Route::get('/blog/category/{category:slug}', [BlogController::class, 'category'])->name('category.show');
    Route::get('/blog/tag/{tag:slug}', [BlogController::class, 'tag'])->name('tag.show');
    Route::get('/blog/{post:slug}', [BlogController::class, 'show'])->name('posts.show');
});