@extends('layouts.frontend')

@section('title', $post->meta_title ?: $post->title)
@section('meta_description', $post->meta_description ?: Str::limit(strip_tags($post->content), 160))
@section('meta_keywords', $post->meta_keywords)
    {{-- Canonical URL --}}
    <link rel="canonical" href="{{ route(get_active_public_route_name('blog.posts.show'), $post->slug) }}" />

@push('styles')
{{-- Add any specific styles for blog post, e.g., syntax highlighting --}}
@endpush

    @push('meta_tags')
    {{-- Open Graph / Facebook --}}
    <meta property="og:type" content="article">
    <meta property="og:url" content="{{ route(get_active_public_route_name('blog.posts.show'), $post->slug) }}">
    <meta property="og:title" content="{{ $post->meta_title ?: $post->title }}">
    <meta property="og:description" content="{{ $post->meta_description ?: Str::limit(strip_tags($post->content), 160) }}">
    @if($post->featured_image)
    <meta property="og:image" content="{{ Storage::url($post->featured_image) }}">
    @endif
    <meta property="article:published_time" content="{{ $post->published_at ? $post->published_at->toIso8601String() : '' }}">
    @if($post->user) <meta property="article:author" content="{{ $post->user->name }}"> @endif

    {{-- Twitter --}}
    <meta property="twitter:card" content="summary_large_image">
    <meta property="twitter:url" content="{{ route(get_active_public_route_name('blog.posts.show'), $post->slug) }}">
    <meta property="twitter:title" content="{{ $post->meta_title ?: $post->title }}">
    <meta property="twitter:description" content="{{ $post->meta_description ?: Str::limit(strip_tags($post->content), 160) }}">
    @if($post->featured_image)
    <meta property="twitter:image" content="{{ Storage::url($post->featured_image) }}">
    @endif
    @endpush

@section('content')
<div class="container mx-auto px-4 py-8">
    <article class="bg-white dark:bg-gray-800 rounded-lg shadow-lg p-6 md:p-8 lg:p-10">
        <h1 class="text-3xl md:text-4xl font-bold text-gray-900 dark:text-gray-100 mb-4">{{ $post->title }}</h1>
        <div class="text-sm text-gray-500 dark:text-gray-400 mb-6">
            <span>Published on {{ $post->published_at->format('F j, Y') }}</span>
            @if($post->user)
                <span>by <a href="#" class="hover:underline">{{ $post->user->name }}</a></span>
            @endif
            @if($post->categories->isNotEmpty())
                <span class="mx-1">|</span> In
                @foreach($post->categories as $category)
                    <a href="{{ route(get_active_public_route_name('blog.category.show'), $category->slug) }}" class="text-purple-600 dark:text-purple-400 hover:underline">{{ $category->name }}</a>{{ !$loop->last ? ',' : '' }}
                @endforeach
            @endif
        </div>

        @if($post->featured_image)
            <img src="{{ Storage::url($post->featured_image) }}" alt="{{ $post->title }}" class="w-full h-auto max-h-[500px] object-cover rounded-md mb-8">
        @endif

        <div class="prose dark:prose-invert max-w-none">
            {!! $post->content !!}
        </div>

        {{-- TODO: Add tags, social sharing, comments section --}}
    </article>
</div>
@endsection