<article class="bg-white dark:bg-gray-800 rounded-lg shadow-md overflow-hidden flex flex-col">
    @if($post->featured_image)
        <a href="{{ route(get_active_public_route_name('blog.posts.show'), $post->slug) }}">
            <img src="{{ Storage::url($post->featured_image) }}" alt="{{ $post->title }}" class="w-full h-48 object-cover">
        </a>
    @endif
    <div class="p-6 flex flex-col flex-grow">
        <h2 class="text-xl font-semibold mb-2"><a href="{{ route(get_active_public_route_name('blog.posts.show'), $post->slug) }}" class="hover:text-purple-600 dark:hover:text-purple-400">{{ $post->title }}</a></h2>
        <p class="text-sm text-gray-500 dark:text-gray-400 mb-3">Published on {{ $post->published_at->format('M d, Y') }} by {{ $post->user->name ?? 'Admin' }}</p>
        <p class="text-gray-700 dark:text-gray-300 line-clamp-3 flex-grow">{{ Str::limit(strip_tags($post->content), 150) }}</p>
        <a href="{{ route(get_active_public_route_name('blog.posts.show'), $post->slug) }}" class="inline-block mt-4 text-purple-600 dark:text-purple-400 hover:underline self-start">Read more &rarr;</a>
    </div>
</article>