@extends('layouts.frontend') {{-- Or your module's frontend layout if different --}}

@section('title', 'Blog - ' . setting('site_name'))
@section('meta_description', 'Read our latest articles and updates.')

@section('content')
<div class="container mx-auto px-4 py-8">
    <h1 class="text-3xl font-bold text-gray-800 dark:text-gray-100 mb-8">Our Blog</h1>

    @if($posts->isEmpty())
        <p class="text-gray-600 dark:text-gray-400">No blog posts found.</p>
    @else
        <div class="grid grid-cols-1 md:grid-cols-2 lg:grid-cols-3 gap-8">
            @foreach($posts as $post)
                @include('blog::frontend.partials._post_card', ['post' => $post])
            @endforeach
        </div>
        <div class="mt-8">
            {{ $posts->links() }}
        </div>
    @endif
</div>
@endsection