@extends('layouts.frontend')

@section('title', 'Category: ' . $category->name . ' - Blog - ' . setting('site_name'))
@section('meta_description', $category->meta_description ?: 'Posts in category: ' . $category->name)
@section('meta_keywords', $category->meta_keywords)

@section('content')
<div class="container mx-auto px-4 py-8">
    <h1 class="text-3xl font-bold text-gray-800 dark:text-gray-100 mb-2">
        Blog Category: <span class="text-purple-600 dark:text-purple-400">{{ $category->name }}</span>
    </h1>
    @if($category->description)
        <p class="text-gray-600 dark:text-gray-400 mb-8">{{ $category->description }}</p>
    @endif

    @if($posts->isEmpty())
        <p class="text-gray-600 dark:text-gray-400">No blog posts found in this category.</p>
    @else
        <div class="grid grid-cols-1 md:grid-cols-2 lg:grid-cols-3 gap-8">
            @foreach($posts as $post)
                @include('blog::frontend.partials._post_card', ['post' => $post]) {{-- Assuming you create a partial --}}
            @endforeach
        </div>
        <div class="mt-8">
            {{ $posts->links() }}
        </div>
    @endif
</div>
@endsection