@csrf
<div class="grid grid-cols-1 md:grid-cols-3 gap-6">
    <div class="md:col-span-2 space-y-6">
        {{-- Title --}}
        <div>
            <label for="title" class="block text-sm font-medium text-gray-700 dark:text-gray-300">Title</label>
            <input type="text" name="title" id="title" value="{{ old('title', $post->title ?? '') }}" required
                   class="mt-1 block w-full shadow-sm sm:text-sm border-gray-300 rounded-md dark:bg-gray-700 dark:text-gray-200 dark:border-gray-600 focus:ring-purple-500 focus:border-purple-500">
            @error('title') <p class="text-red-500 text-xs mt-1">{{ $message }}</p> @enderror
        </div>

        {{-- Content (Rich Text Editor Recommended) --}}
        <div>
            <label for="content" class="block text-sm font-medium text-gray-700 dark:text-gray-300">Content</label>
            <textarea name="content" id="content" rows="10"
                      class="mt-1 block w-full shadow-sm sm:text-sm border-gray-300 rounded-md dark:bg-gray-700 dark:text-gray-200 dark:border-gray-600 focus:ring-purple-500 focus:border-purple-500">{{ old('content', $post->content ?? '') }}</textarea>
            @error('content') <p class="text-red-500 text-xs mt-1">{{ $message }}</p> @enderror
        </div>

        {{-- SEO Meta Fields --}}
        <div class="space-y-4 p-4 border rounded-md dark:border-gray-700">
            <h3 class="text-lg font-medium">SEO Settings</h3>
            <div>
                <label for="meta_title" class="block text-sm font-medium text-gray-700 dark:text-gray-300">Meta Title</label>
                <input type="text" name="meta_title" id="meta_title" value="{{ old('meta_title', $post->meta_title ?? '') }}"
                       class="mt-1 block w-full shadow-sm sm:text-sm border-gray-300 rounded-md dark:bg-gray-700 dark:text-gray-200 dark:border-gray-600">
            </div>
            <div>
                <label for="meta_description" class="block text-sm font-medium text-gray-700 dark:text-gray-300">Meta Description</label>
                <textarea name="meta_description" id="meta_description" rows="3"
                          class="mt-1 block w-full shadow-sm sm:text-sm border-gray-300 rounded-md dark:bg-gray-700 dark:text-gray-200 dark:border-gray-600">{{ old('meta_description', $post->meta_description ?? '') }}</textarea>
            </div>
            <div>
                <label for="meta_keywords" class="block text-sm font-medium text-gray-700 dark:text-gray-300">Meta Keywords (comma-separated)</label>
                <input type="text" name="meta_keywords" id="meta_keywords" value="{{ old('meta_keywords', $post->meta_keywords ?? '') }}"
                       class="mt-1 block w-full shadow-sm sm:text-sm border-gray-300 rounded-md dark:bg-gray-700 dark:text-gray-200 dark:border-gray-600">
            </div>
        </div>
    </div>

    <div class="md:col-span-1 space-y-6">
        {{-- Publish Status --}}
        <div class="bg-white dark:bg-gray-800 p-4 rounded-md shadow">
            <div class="flex items-start">
                <div class="flex items-center h-5">
                    <input id="is_published" name="is_published" type="checkbox" value="1"
                           {{ old('is_published', isset($post) && $post->is_published) ? 'checked' : '' }}
                           class="focus:ring-purple-500 h-4 w-4 text-purple-600 border-gray-300 rounded dark:bg-gray-700 dark:border-gray-600">
                </div>
                <div class="ml-3 text-sm">
                    <label for="is_published" class="font-medium text-gray-700 dark:text-gray-300">Publish Post</label>
                    <p class="text-gray-500 dark:text-gray-400">Make this post publicly visible.</p>
                </div>
            </div>
            <div class="mt-4">
                <label for="published_at_date" class="block text-sm font-medium text-gray-700 dark:text-gray-300">Publish Date & Time (Optional)</label>
                <div class="flex space-x-2 mt-1">
                    <input type="date" name="published_at_date" id="published_at_date" value="{{ old('published_at_date', isset($post) && $post->published_at ? $post->published_at->format('Y-m-d') : '') }}" class="form-input rounded-md dark:bg-gray-700 dark:text-gray-200 dark:border-gray-600 w-1/2">
                    <input type="time" name="published_at_time" id="published_at_time" value="{{ old('published_at_time', isset($post) && $post->published_at ? $post->published_at->format('H:i') : '') }}" class="form-input rounded-md dark:bg-gray-700 dark:text-gray-200 dark:border-gray-600 w-1/2">
                </div>
                <p class="text-xs text-gray-500 mt-1">If not set and "Publish" is checked, current time will be used.</p>
            </div>
        </div>

        {{-- Featured Image --}}
        <div class="bg-white dark:bg-gray-800 p-4 rounded-md shadow">
            <label for="featured_image_file" class="block text-sm font-medium text-gray-700 dark:text-gray-300">Featured Image</label>
            <input type="file" name="featured_image_file" id="featured_image_file" class="mt-1 block w-full text-sm text-gray-500 file:mr-4 file:py-2 file:px-4 file:rounded-full file:border-0 file:text-sm file:font-semibold file:bg-purple-50 file:text-purple-700 hover:file:bg-purple-100 dark:file:bg-purple-700 dark:file:text-purple-100 dark:hover:file:bg-purple-600">
            @if(isset($post) && $post->featured_image)
            <div class="mt-2">
                <img src="{{ Storage::url($post->featured_image) }}" alt="Current image" class="max-h-40 rounded">
                <p class="text-xs text-gray-500 mt-1">Current image. Upload a new one to replace.</p>
            </div>
            @endif
            @error('featured_image_file') <p class="text-red-500 text-xs mt-1">{{ $message }}</p> @enderror
        </div>

        {{-- Categories --}}
        <div class="bg-white dark:bg-gray-800 p-4 rounded-md shadow">
            <label class="block text-sm font-medium text-gray-700 dark:text-gray-300">Categories</label>
            <div class="mt-2 space-y-2 max-h-60 overflow-y-auto border dark:border-gray-600 p-2 rounded-md">
                @foreach($categories as $category)
                <div class="flex items-center">
                    <input id="category_{{ $category->id }}" name="categories[]" type="checkbox" value="{{ $category->id }}"
                           {{ (isset($post) && $post->categories->contains($category->id)) || (is_array(old('categories')) && in_array($category->id, old('categories'))) ? 'checked' : '' }}
                           class="focus:ring-purple-500 h-4 w-4 text-purple-600 border-gray-300 rounded dark:bg-gray-700 dark:border-gray-600">
                    <label for="category_{{ $category->id }}" class="ml-2 text-sm text-gray-700 dark:text-gray-300">{{ $category->name }}</label>
                </div>
                @endforeach
            </div>
        </div>

        {{-- Tags --}}
        <div class="bg-white dark:bg-gray-800 p-4 rounded-md shadow">
            <label for="tags" class="block text-sm font-medium text-gray-700 dark:text-gray-300">Tags (comma-separated)</label>
            <input type="text" name="tags" id="tags" value="{{ old('tags', isset($post) ? $post->tags->pluck('name')->implode(', ') : '') }}"
                   class="mt-1 block w-full shadow-sm sm:text-sm border-gray-300 rounded-md dark:bg-gray-700 dark:text-gray-200 dark:border-gray-600 focus:ring-purple-500 focus:border-purple-500"
                   placeholder="e.g., tech, laravel, news">
        </div>

        {{-- Slug (Optional, auto-generated if empty) --}}
        <div class="bg-white dark:bg-gray-800 p-4 rounded-md shadow">
            <label for="slug" class="block text-sm font-medium text-gray-700 dark:text-gray-300">Slug (Optional)</label>
            <input type="text" name="slug" id="slug" value="{{ old('slug', $post->slug ?? '') }}"
                   class="mt-1 block w-full shadow-sm sm:text-sm border-gray-300 rounded-md dark:bg-gray-700 dark:text-gray-200 dark:border-gray-600 focus:ring-purple-500 focus:border-purple-500">
            <p class="text-xs text-gray-500 mt-1">If left empty, it will be auto-generated from the title.</p>
            @error('slug') <p class="text-red-500 text-xs mt-1">{{ $message }}</p> @enderror
        </div>
    </div>
</div>

<div class="mt-8 pt-5">
    <div class="flex justify-end">
        <a href="{{ route('admin.blog.posts.index') }}" class="bg-gray-200 hover:bg-gray-300 text-gray-700 font-bold py-2 px-4 rounded mr-2 dark:bg-gray-700 dark:hover:bg-gray-600 dark:text-gray-200">
            Cancel
        </a>
        <button type="submit" class="bg-purple-600 hover:bg-purple-700 text-white font-bold py-2 px-4 rounded">
            {{ isset($post) ? 'Update Post' : 'Create Post' }}
        </button>
    </div>
</div>

@push('scripts')
<script>
    document.addEventListener('DOMContentLoaded', function () {
        if (document.querySelector('#content')) {
            ClassicEditor
                .create(document.querySelector('#content'))
                .catch(error => {
                    console.error(error);
                });
        }
    });
</script>
@endpush