<?php

namespace Modules\Blog\Providers;

use Illuminate\Foundation\Support\Providers\RouteServiceProvider as ServiceProvider;
use Illuminate\Support\Facades\Route;

class RouteServiceProvider extends ServiceProvider
{
    protected string $name = 'Blog';
    /**
     * The module namespace to assume when generating URLs to actions.
     * @var string
     */
    protected string $moduleNamespace = 'Modules\Blog\Http\Controllers';

    /**
     * Called before routes are registered.
     *
     * Register any model bindings or pattern based filters.
     */
    public function boot(): void
    {
        parent::boot();
    }

    /**
     * Define the routes for the application.
     */
    public function map(): void
    {
        $this->mapApiRoutes();
        $this->mapAdminRoutes();
        $this->mapWebRoutes();
    }

    /**
     * Define the "web" routes for the application.
     *
     * These routes all receive session state, CSRF protection, etc.
     */
    protected function mapWebRoutes(): void
    {
        Route::middleware('web')
            // No specific namespace for frontend controllers by default,
            // they are typically in Modules\Blog\Http\Controllers\Frontend
            ->group(module_path($this->name, '/routes/web.php'));
    }

    /**
     * Define the "api" routes for the application.
     *
     * These routes are typically stateless.
     */
    protected function mapApiRoutes(): void
    {
        Route::middleware('api')
            ->prefix('api') // Standard API prefix
            ->name('api.')   // Standard API route name prefix
            ->group(module_path($this->name, '/routes/api.php'));
    }

    /**
     * Define the "admin" routes for the application.
     *
     * These routes are typically stateless.
     */
    protected function mapAdminRoutes(): void
    {
        Route::middleware(['web', \App\Http\Middleware\IsAdminMiddleware::class]) // Apply necessary middleware
             ->prefix('admin/' . strtolower($this->name)) // e.g., admin/blog
             ->name('admin.' . strtolower($this->name) . '.')     // e.g., admin.blog. (using name() for consistency)
             // If your admin controllers are in 'Modules\Blog\Http\Controllers\Admin'
             // and you are NOT using full namespaces in your admin.php routes, uncomment the line below.
             // ->namespace($this->moduleNamespace . '\\Admin')
             ->group(module_path($this->name, '/routes/admin.php')); // Corrected path to lowercase 'routes'
    }
}
