<?php

use Illuminate\Support\Facades\Route;
// Remove if AuthorizeNetGatewayController is not used for user-facing actions
use Modules\AuthorizeNetGateway\Http\Controllers\AuthorizeNetWebhookController;
use Modules\AuthorizeNetGateway\Http\Controllers\AuthorizeNetSubscriptionController; // Added

// Webhook route for Authorize.Net notifications.
// This route should typically be exempt from CSRF protection.
Route::post('authorizenetgateway/webhook', [AuthorizeNetWebhookController::class, 'handle'])->name('authorizenetgateway.webhook');

Route::middleware(['web', 'auth']) // User must be authenticated
    ->prefix('subscribe/authorizenet')
    ->name('subscription.authorizenet.')
    ->group(function () {
        // The {subscriptionPlan:slug} will use route model binding
        // This route shows the form with Accept.js
        Route::get('checkout/{subscriptionPlan:slug}', [AuthorizeNetSubscriptionController::class, 'showCheckoutForm'])->name('checkout');
        // This route processes the payment nonce from Accept.js
        Route::post('process-subscription/{subscriptionPlan:slug}', [AuthorizeNetSubscriptionController::class, 'processSubscriptionWithAcceptJs'])->name('processSubscription');
    });

Route::middleware(['web', 'auth'])
    ->prefix('wallet/authorizenet')
    ->name('wallet.authorizenet.')
    ->group(function () {
        // The WalletController redirects to this route with amount in GET
        Route::get('deposit-form', [AuthorizeNetSubscriptionController::class, 'showWalletDepositForm'])->name('depositForm');
        Route::post('process-deposit', [AuthorizeNetSubscriptionController::class, 'processWalletDepositWithAcceptJs'])->name('processDeposit');
    });
